// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Azure Key Vault reference. */
@Fluent
public final class KeyVaultReference {
    /*
     * Azure Key Vault resource id.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /** Creates an instance of KeyVaultReference class. */
    public KeyVaultReference() {
    }

    /**
     * Get the id property: Azure Key Vault resource id.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Azure Key Vault resource id.
     *
     * @param id the id value to set.
     * @return the KeyVaultReference object itself.
     */
    public KeyVaultReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property id in model KeyVaultReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultReference.class);
}
