// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExtendedInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List of deployments. */
@Fluent
public final class DeploymentListResult {
    /*
     * An array of deployments.
     */
    @JsonProperty(value = "value")
    private List<DeploymentExtendedInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /** Creates an instance of DeploymentListResult class. */
    public DeploymentListResult() {
    }

    /**
     * Get the value property: An array of deployments.
     *
     * @return the value value.
     */
    public List<DeploymentExtendedInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of deployments.
     *
     * @param value the value value to set.
     * @return the DeploymentListResult object itself.
     */
    public DeploymentListResult withValue(List<DeploymentExtendedInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
