// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resources.fluent.models.PolicyDefinitionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List of policy definitions. */
@Fluent
public final class PolicyDefinitionListResult {
    /*
     * An array of policy definitions.
     */
    @JsonProperty(value = "value")
    private List<PolicyDefinitionInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of PolicyDefinitionListResult class. */
    public PolicyDefinitionListResult() {
    }

    /**
     * Get the value property: An array of policy definitions.
     *
     * @return the value value.
     */
    public List<PolicyDefinitionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of policy definitions.
     *
     * @param value the value value to set.
     * @return the PolicyDefinitionListResult object itself.
     */
    public PolicyDefinitionListResult withValue(List<PolicyDefinitionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to use for getting the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the PolicyDefinitionListResult object itself.
     */
    public PolicyDefinitionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
