// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The selector expression. */
@Fluent
public final class Selector {
    /*
     * The selector kind.
     */
    @JsonProperty(value = "kind")
    private SelectorKind kind;

    /*
     * The list of values to filter in.
     */
    @JsonProperty(value = "in")
    private List<String> in;

    /*
     * The list of values to filter out.
     */
    @JsonProperty(value = "notIn")
    private List<String> notIn;

    /** Creates an instance of Selector class. */
    public Selector() {
    }

    /**
     * Get the kind property: The selector kind.
     *
     * @return the kind value.
     */
    public SelectorKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The selector kind.
     *
     * @param kind the kind value to set.
     * @return the Selector object itself.
     */
    public Selector withKind(SelectorKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the in property: The list of values to filter in.
     *
     * @return the in value.
     */
    public List<String> in() {
        return this.in;
    }

    /**
     * Set the in property: The list of values to filter in.
     *
     * @param in the in value to set.
     * @return the Selector object itself.
     */
    public Selector withIn(List<String> in) {
        this.in = in;
        return this;
    }

    /**
     * Get the notIn property: The list of values to filter out.
     *
     * @return the notIn value.
     */
    public List<String> notIn() {
        return this.notIn;
    }

    /**
     * Set the notIn property: The list of values to filter out.
     *
     * @param notIn the notIn value to set.
     * @return the Selector object itself.
     */
    public Selector withNotIn(List<String> notIn) {
        this.notIn = notIn;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
