// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluent.models.ManagementLockObjectInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ManagementLocksClient. */
public interface ManagementLocksClient
    extends InnerSupportsGet<ManagementLockObjectInner>,
        InnerSupportsListing<ManagementLockObjectInner>,
        InnerSupportsDelete<Void> {
    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group to lock.
     * @param lockName The lock name. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %,
     *     &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagementLockObjectInner>> createOrUpdateAtResourceGroupLevelWithResponseAsync(
        String resourceGroupName, String lockName, ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group to lock.
     * @param lockName The lock name. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %,
     *     &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagementLockObjectInner> createOrUpdateAtResourceGroupLevelAsync(
        String resourceGroupName, String lockName, ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group to lock.
     * @param lockName The lock name. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %,
     *     &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagementLockObjectInner createOrUpdateAtResourceGroupLevel(
        String resourceGroupName, String lockName, ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group to lock.
     * @param lockName The lock name. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt; %,
     *     &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagementLockObjectInner> createOrUpdateAtResourceGroupLevelWithResponse(
        String resourceGroupName, String lockName, ManagementLockObjectInner parameters, Context context);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the lock.
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the lock.
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the lock.
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the lock.
     * @param lockName The name of lock to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String lockName, Context context);

    /**
     * Gets a management lock at the resource group level.
     *
     * @param resourceGroupName The name of the locked resource group.
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock at the resource group level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagementLockObjectInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String lockName);

    /**
     * Gets a management lock at the resource group level.
     *
     * @param resourceGroupName The name of the locked resource group.
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock at the resource group level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagementLockObjectInner> getByResourceGroupAsync(String resourceGroupName, String lockName);

    /**
     * Gets a management lock at the resource group level.
     *
     * @param resourceGroupName The name of the locked resource group.
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock at the resource group level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagementLockObjectInner getByResourceGroup(String resourceGroupName, String lockName);

    /**
     * Gets a management lock at the resource group level.
     *
     * @param resourceGroupName The name of the locked resource group.
     * @param lockName The name of the lock to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock at the resource group level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagementLockObjectInner> getByResourceGroupWithResponse(
        String resourceGroupName, String lockName, Context context);

    /**
     * Create or update a management lock by scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use
     *     '/subscriptions/{subscriptionId}' for subscriptions,
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
     *     for resources.
     * @param lockName The name of lock.
     * @param parameters Create or update management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagementLockObjectInner>> createOrUpdateByScopeWithResponseAsync(
        String scope, String lockName, ManagementLockObjectInner parameters);

    /**
     * Create or update a management lock by scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use
     *     '/subscriptions/{subscriptionId}' for subscriptions,
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
     *     for resources.
     * @param lockName The name of lock.
     * @param parameters Create or update management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagementLockObjectInner> createOrUpdateByScopeAsync(
        String scope, String lockName, ManagementLockObjectInner parameters);

    /**
     * Create or update a management lock by scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use
     *     '/subscriptions/{subscriptionId}' for subscriptions,
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
     *     for resources.
     * @param lockName The name of lock.
     * @param parameters Create or update management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagementLockObjectInner createOrUpdateByScope(
        String scope, String lockName, ManagementLockObjectInner parameters);

    /**
     * Create or update a management lock by scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use
     *     '/subscriptions/{subscriptionId}' for subscriptions,
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
     *     for resources.
     * @param lockName The name of lock.
     * @param parameters Create or update management lock parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagementLockObjectInner> createOrUpdateByScopeWithResponse(
        String scope, String lockName, ManagementLockObjectInner parameters, Context context);

    /**
     * Delete a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteByScopeWithResponseAsync(String scope, String lockName);

    /**
     * Delete a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteByScopeAsync(String scope, String lockName);

    /**
     * Delete a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteByScope(String scope, String lockName);

    /**
     * Delete a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteByScopeWithResponse(String scope, String lockName, Context context);

    /**
     * Get a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock by scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagementLockObjectInner>> getByScopeWithResponseAsync(String scope, String lockName);

    /**
     * Get a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock by scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagementLockObjectInner> getByScopeAsync(String scope, String lockName);

    /**
     * Get a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock by scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagementLockObjectInner getByScope(String scope, String lockName);

    /**
     * Get a management lock by scope.
     *
     * @param scope The scope for the lock.
     * @param lockName The name of lock.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock by scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagementLockObjectInner> getByScopeWithResponse(String scope, String lockName, Context context);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource to lock.
     * @param resourceProviderNamespace The resource provider namespace of the resource to lock.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to lock.
     * @param resourceName The name of the resource to lock.
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt;
     *     %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters Parameters for creating or updating a management lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagementLockObjectInner>> createOrUpdateAtResourceLevelWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName,
        ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource to lock.
     * @param resourceProviderNamespace The resource provider namespace of the resource to lock.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to lock.
     * @param resourceName The name of the resource to lock.
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt;
     *     %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters Parameters for creating or updating a management lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagementLockObjectInner> createOrUpdateAtResourceLevelAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName,
        ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource to lock.
     * @param resourceProviderNamespace The resource provider namespace of the resource to lock.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to lock.
     * @param resourceName The name of the resource to lock.
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt;
     *     %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters Parameters for creating or updating a management lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagementLockObjectInner createOrUpdateAtResourceLevel(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName,
        ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource to lock.
     * @param resourceProviderNamespace The resource provider namespace of the resource to lock.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource to lock.
     * @param resourceName The name of the resource to lock.
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt;
     *     %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters Parameters for creating or updating a management lock.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagementLockObjectInner> createOrUpdateAtResourceLevelWithResponse(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName,
        ManagementLockObjectInner parameters,
        Context context);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource with the lock to delete.
     * @param resourceProviderNamespace The resource provider namespace of the resource with the lock to delete.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource with the lock to delete.
     * @param resourceName The name of the resource with the lock to delete.
     * @param lockName The name of the lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAtResourceLevelWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource with the lock to delete.
     * @param resourceProviderNamespace The resource provider namespace of the resource with the lock to delete.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource with the lock to delete.
     * @param resourceName The name of the resource with the lock to delete.
     * @param lockName The name of the lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtResourceLevelAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource with the lock to delete.
     * @param resourceProviderNamespace The resource provider namespace of the resource with the lock to delete.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource with the lock to delete.
     * @param resourceName The name of the resource with the lock to delete.
     * @param lockName The name of the lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtResourceLevel(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param resourceGroupName The name of the resource group containing the resource with the lock to delete.
     * @param resourceProviderNamespace The resource provider namespace of the resource with the lock to delete.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the resource with the lock to delete.
     * @param resourceName The name of the resource with the lock to delete.
     * @param lockName The name of the lock to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAtResourceLevelWithResponse(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName,
        Context context);

    /**
     * Get the management lock of a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceType The type of the resource.
     * @param resourceName The name of the resource.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the management lock of a resource or any level below resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagementLockObjectInner>> getAtResourceLevelWithResponseAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName);

    /**
     * Get the management lock of a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceType The type of the resource.
     * @param resourceName The name of the resource.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the management lock of a resource or any level below resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagementLockObjectInner> getAtResourceLevelAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName);

    /**
     * Get the management lock of a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceType The type of the resource.
     * @param resourceName The name of the resource.
     * @param lockName The name of lock.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the management lock of a resource or any level below resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagementLockObjectInner getAtResourceLevel(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName);

    /**
     * Get the management lock of a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath An extra path parameter needed in some services, like SQL Databases.
     * @param resourceType The type of the resource.
     * @param resourceName The name of the resource.
     * @param lockName The name of lock.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the management lock of a resource or any level below resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagementLockObjectInner> getAtResourceLevelWithResponse(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String lockName,
        Context context);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt;
     *     %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagementLockObjectInner>> createOrUpdateAtSubscriptionLevelWithResponseAsync(
        String lockName, ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt;
     *     %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagementLockObjectInner> createOrUpdateAtSubscriptionLevelAsync(
        String lockName, ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt;
     *     %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagementLockObjectInner createOrUpdateAtSubscriptionLevel(String lockName, ManagementLockObjectInner parameters);

    /**
     * When you apply a lock at a parent scope, all child resources inherit the same lock. To create management locks,
     * you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/* actions. Of the built-in
     * roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain &lt;, &gt;
     *     %, &amp;, :, \, ?, /, or any control characters.
     * @param parameters The management lock parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the lock information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagementLockObjectInner> createOrUpdateAtSubscriptionLevelWithResponse(
        String lockName, ManagementLockObjectInner parameters, Context context);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAtSubscriptionLevelWithResponseAsync(String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtSubscriptionLevelAsync(String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtSubscriptionLevel(String lockName);

    /**
     * To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
     * actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
     *
     * @param lockName The name of lock to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAtSubscriptionLevelWithResponse(String lockName, Context context);

    /**
     * Gets a management lock at the subscription level.
     *
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock at the subscription level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagementLockObjectInner>> getAtSubscriptionLevelWithResponseAsync(String lockName);

    /**
     * Gets a management lock at the subscription level.
     *
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock at the subscription level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagementLockObjectInner> getAtSubscriptionLevelAsync(String lockName);

    /**
     * Gets a management lock at the subscription level.
     *
     * @param lockName The name of the lock to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock at the subscription level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagementLockObjectInner getAtSubscriptionLevel(String lockName);

    /**
     * Gets a management lock at the subscription level.
     *
     * @param lockName The name of the lock to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a management lock at the subscription level.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagementLockObjectInner> getAtSubscriptionLevelWithResponse(String lockName, Context context);

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagementLockObjectInner> listByResourceGroupAsync(String resourceGroupName, String filter);

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagementLockObjectInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagementLockObjectInner> listByResourceGroup(String resourceGroupName);

    /**
     * Gets all the management locks for a resource group.
     *
     * @param resourceGroupName The name of the resource group containing the locks to get.
     * @param filter The filter to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagementLockObjectInner> listByResourceGroup(
        String resourceGroupName, String filter, Context context);

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a resource or any level below resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagementLockObjectInner> listAtResourceLevelAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter);

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a resource or any level below resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagementLockObjectInner> listAtResourceLevelAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName);

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a resource or any level below resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagementLockObjectInner> listAtResourceLevel(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName);

    /**
     * Gets all the management locks for a resource or any level below resource.
     *
     * @param resourceGroupName The name of the resource group containing the locked resource. The name is case
     *     insensitive.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param parentResourcePath The parent resource identity.
     * @param resourceType The resource type of the locked resource.
     * @param resourceName The name of the locked resource.
     * @param filter The filter to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a resource or any level below resource.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagementLockObjectInner> listAtResourceLevel(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context);

    /**
     * Gets all the management locks for a subscription.
     *
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagementLockObjectInner> listAsync(String filter);

    /**
     * Gets all the management locks for a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagementLockObjectInner> listAsync();

    /**
     * Gets all the management locks for a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagementLockObjectInner> list();

    /**
     * Gets all the management locks for a subscription.
     *
     * @param filter The filter to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagementLockObjectInner> list(String filter, Context context);

    /**
     * Gets all the management locks for a scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use
     *     '/subscriptions/{subscriptionId}' for subscriptions,
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
     *     for resources.
     * @param filter The filter to apply on the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagementLockObjectInner> listByScopeAsync(String scope, String filter);

    /**
     * Gets all the management locks for a scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use
     *     '/subscriptions/{subscriptionId}' for subscriptions,
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
     *     for resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagementLockObjectInner> listByScopeAsync(String scope);

    /**
     * Gets all the management locks for a scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use
     *     '/subscriptions/{subscriptionId}' for subscriptions,
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
     *     for resources.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagementLockObjectInner> listByScope(String scope);

    /**
     * Gets all the management locks for a scope.
     *
     * @param scope The scope for the lock. When providing a scope for the assignment, use
     *     '/subscriptions/{subscriptionId}' for subscriptions,
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for resource groups, and
     *     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
     *     for resources.
     * @param filter The filter to apply on the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the management locks for a scope.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagementLockObjectInner> listByScope(String scope, String filter, Context context);
}
