// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluent.PolicyAssignmentsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicyAssignmentInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.models.PolicyAssignmentListResult;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in PolicyAssignmentsClient. */
public final class PolicyAssignmentsClientImpl
    implements InnerSupportsListing<PolicyAssignmentInner>,
        InnerSupportsDelete<PolicyAssignmentInner>,
        PolicyAssignmentsClient {
    private final ClientLogger logger = new ClientLogger(PolicyAssignmentsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final PolicyAssignmentsService service;

    /** The service client containing this operation class. */
    private final PolicyClientImpl client;

    /**
     * Initializes an instance of PolicyAssignmentsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    PolicyAssignmentsClientImpl(PolicyClientImpl client) {
        this.service =
            RestProxy.create(PolicyAssignmentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PolicyClientPolicyAssignments to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PolicyClientPolicyAs")
    private interface PolicyAssignmentsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Delete("/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentInner>> delete(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("policyAssignmentName") String policyAssignmentName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put("/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentInner>> create(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("policyAssignmentName") String policyAssignmentName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PolicyAssignmentInner parameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("policyAssignmentName") String policyAssignmentName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization"
                + "/policyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam(value = "$filter", encoded = true) String filter,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}"
                + "/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization"
                + "/policyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentListResult>> listForResource(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceProviderNamespace") String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/providers/Microsoft.Management/managementgroups/{managementGroupId}/providers/Microsoft.Authorization"
                + "/policyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentListResult>> listForManagementGroup(
            @HostParam("$host") String endpoint,
            @PathParam("managementGroupId") String managementGroupId,
            @QueryParam(value = "$filter", encoded = true) String filter,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("$filter") String filter,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Delete("/{policyAssignmentId}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentInner>> deleteById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "policyAssignmentId", encoded = true) String policyAssignmentId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put("/{policyAssignmentId}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentInner>> createById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "policyAssignmentId", encoded = true) String policyAssignmentId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PolicyAssignmentInner parameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/{policyAssignmentId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentInner>> getById(
            @HostParam("$host") String endpoint,
            @PathParam(value = "policyAssignmentId", encoded = true) String policyAssignmentId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentListResult>> listForResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentListResult>> listForResourceNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentListResult>> listForManagementGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyAssignmentListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * This operation deletes a policy assignment, given its name and the scope it was created in. The scope of a policy
     * assignment is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyAssignmentInner>> deleteWithResponseAsync(String scope, String policyAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            scope,
                            policyAssignmentName,
                            this.client.getApiVersion(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation deletes a policy assignment, given its name and the scope it was created in. The scope of a policy
     * assignment is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyAssignmentInner>> deleteWithResponseAsync(
        String scope, String policyAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .delete(this.client.getEndpoint(), scope, policyAssignmentName, this.client.getApiVersion(), context);
    }

    /**
     * This operation deletes a policy assignment, given its name and the scope it was created in. The scope of a policy
     * assignment is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyAssignmentInner> deleteAsync(String scope, String policyAssignmentName) {
        return deleteWithResponseAsync(scope, policyAssignmentName)
            .flatMap(
                (Response<PolicyAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation deletes a policy assignment, given its name and the scope it was created in. The scope of a policy
     * assignment is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyAssignmentInner delete(String scope, String policyAssignmentName) {
        return deleteAsync(scope, policyAssignmentName).block();
    }

    /**
     * This operation deletes a policy assignment, given its name and the scope it was created in. The scope of a policy
     * assignment is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyAssignmentInner> deleteWithResponse(
        String scope, String policyAssignmentName, Context context) {
        return deleteWithResponseAsync(scope, policyAssignmentName, context).block();
    }

    /**
     * This operation creates or updates a policy assignment with the given scope and name. Policy assignments apply to
     * all resources contained within their scope. For example, when you assign a policy at resource group scope, that
     * policy applies to all resources in the group.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment.
     * @param parameters The policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyAssignmentInner>> createWithResponseAsync(
        String scope, String policyAssignmentName, PolicyAssignmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            scope,
                            policyAssignmentName,
                            this.client.getApiVersion(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation creates or updates a policy assignment with the given scope and name. Policy assignments apply to
     * all resources contained within their scope. For example, when you assign a policy at resource group scope, that
     * policy applies to all resources in the group.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment.
     * @param parameters The policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyAssignmentInner>> createWithResponseAsync(
        String scope, String policyAssignmentName, PolicyAssignmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                scope,
                policyAssignmentName,
                this.client.getApiVersion(),
                parameters,
                context);
    }

    /**
     * This operation creates or updates a policy assignment with the given scope and name. Policy assignments apply to
     * all resources contained within their scope. For example, when you assign a policy at resource group scope, that
     * policy applies to all resources in the group.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment.
     * @param parameters The policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyAssignmentInner> createAsync(
        String scope, String policyAssignmentName, PolicyAssignmentInner parameters) {
        return createWithResponseAsync(scope, policyAssignmentName, parameters)
            .flatMap(
                (Response<PolicyAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation creates or updates a policy assignment with the given scope and name. Policy assignments apply to
     * all resources contained within their scope. For example, when you assign a policy at resource group scope, that
     * policy applies to all resources in the group.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment.
     * @param parameters The policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyAssignmentInner create(String scope, String policyAssignmentName, PolicyAssignmentInner parameters) {
        return createAsync(scope, policyAssignmentName, parameters).block();
    }

    /**
     * This operation creates or updates a policy assignment with the given scope and name. Policy assignments apply to
     * all resources contained within their scope. For example, when you assign a policy at resource group scope, that
     * policy applies to all resources in the group.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment.
     * @param parameters The policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyAssignmentInner> createWithResponse(
        String scope, String policyAssignmentName, PolicyAssignmentInner parameters, Context context) {
        return createWithResponseAsync(scope, policyAssignmentName, parameters, context).block();
    }

    /**
     * This operation retrieves a single policy assignment, given its name and the scope it was created at.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyAssignmentInner>> getWithResponseAsync(String scope, String policyAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            scope,
                            policyAssignmentName,
                            this.client.getApiVersion(),
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves a single policy assignment, given its name and the scope it was created at.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyAssignmentInner>> getWithResponseAsync(
        String scope, String policyAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyAssignmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .get(this.client.getEndpoint(), scope, policyAssignmentName, this.client.getApiVersion(), context);
    }

    /**
     * This operation retrieves a single policy assignment, given its name and the scope it was created at.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyAssignmentInner> getAsync(String scope, String policyAssignmentName) {
        return getWithResponseAsync(scope, policyAssignmentName)
            .flatMap(
                (Response<PolicyAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation retrieves a single policy assignment, given its name and the scope it was created at.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyAssignmentInner get(String scope, String policyAssignmentName) {
        return getAsync(scope, policyAssignmentName).block();
    }

    /**
     * This operation retrieves a single policy assignment, given its name and the scope it was created at.
     *
     * @param scope The scope of the policy assignment. Valid scopes are: management group (format:
     *     '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     *     '/subscriptions/{subscriptionId}'), resource group (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyAssignmentName The name of the policy assignment to get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyAssignmentInner> getWithResponse(String scope, String policyAssignmentName, Context context) {
        return getWithResponseAsync(scope, policyAssignmentName, context).block();
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()' or
     * 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource group, including those that apply directly or apply from containing
     * scopes, as well as any applied to resources contained within the resource group. If $filter=atScope() is
     * provided, the returned list includes all policy assignments that apply to the resource group, which is everything
     * in the unfiltered list except those applied to resources contained within the resource group. If
     * $filter=policyDefinitionId eq '{value}' is provided, the returned list includes all policy assignments of the
     * policy definition whose id is {value} that apply to the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains policy assignments.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            filter,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<PolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()' or
     * 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource group, including those that apply directly or apply from containing
     * scopes, as well as any applied to resources contained within the resource group. If $filter=atScope() is
     * provided, the returned list includes all policy assignments that apply to the resource group, which is everything
     * in the unfiltered list except those applied to resources contained within the resource group. If
     * $filter=policyDefinitionId eq '{value}' is provided, the returned list includes all policy assignments of the
     * policy definition whose id is {value} that apply to the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains policy assignments.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                filter,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()' or
     * 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource group, including those that apply directly or apply from containing
     * scopes, as well as any applied to resources contained within the resource group. If $filter=atScope() is
     * provided, the returned list includes all policy assignments that apply to the resource group, which is everything
     * in the unfiltered list except those applied to resources contained within the resource group. If
     * $filter=policyDefinitionId eq '{value}' is provided, the returned list includes all policy assignments of the
     * policy definition whose id is {value} that apply to the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains policy assignments.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyAssignmentInner> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()' or
     * 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource group, including those that apply directly or apply from containing
     * scopes, as well as any applied to resources contained within the resource group. If $filter=atScope() is
     * provided, the returned list includes all policy assignments that apply to the resource group, which is everything
     * in the unfiltered list except those applied to resources contained within the resource group. If
     * $filter=policyDefinitionId eq '{value}' is provided, the returned list includes all policy assignments of the
     * policy definition whose id is {value} that apply to the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains policy assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyAssignmentInner> listByResourceGroupAsync(String resourceGroupName) {
        final String filter = null;
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()' or
     * 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource group, including those that apply directly or apply from containing
     * scopes, as well as any applied to resources contained within the resource group. If $filter=atScope() is
     * provided, the returned list includes all policy assignments that apply to the resource group, which is everything
     * in the unfiltered list except those applied to resources contained within the resource group. If
     * $filter=policyDefinitionId eq '{value}' is provided, the returned list includes all policy assignments of the
     * policy definition whose id is {value} that apply to the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains policy assignments.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicyAssignmentInner> listByResourceGroupAsync(
        String resourceGroupName, String filter, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, context),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()' or
     * 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource group, including those that apply directly or apply from containing
     * scopes, as well as any applied to resources contained within the resource group. If $filter=atScope() is
     * provided, the returned list includes all policy assignments that apply to the resource group, which is everything
     * in the unfiltered list except those applied to resources contained within the resource group. If
     * $filter=policyDefinitionId eq '{value}' is provided, the returned list includes all policy assignments of the
     * policy definition whose id is {value} that apply to the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains policy assignments.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyAssignmentInner> listByResourceGroup(
        String resourceGroupName, String filter, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter, context));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()' or
     * 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource group, including those that apply directly or apply from containing
     * scopes, as well as any applied to resources contained within the resource group. If $filter=atScope() is
     * provided, the returned list includes all policy assignments that apply to the resource group, which is everything
     * in the unfiltered list except those applied to resources contained within the resource group. If
     * $filter=policyDefinitionId eq '{value}' is provided, the returned list includes all policy assignments of the
     * policy definition whose id is {value} that apply to the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains policy assignments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyAssignmentInner> listByResourceGroup(String resourceGroupName) {
        final String filter = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()'
     * or 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource, including those that apply directly or from all containing scopes, as
     * well as any applied to resources contained within the resource. If $filter=atScope() is provided, the returned
     * list includes all policy assignments that apply to the resource, which is everything in the unfiltered list
     * except those applied to resources contained within the resource. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value} that
     * apply to the resource. Three parameters plus the resource name are used to identify a specific resource. If the
     * resource is not part of a parent resource (the more common case), the parent resource path should not be provided
     * (or provided as ''). For example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web',
     * {parentResourcePath} == '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of
     * a parent resource, then all parameters should be provided. For example a virtual machine DNS name could be
     * specified as ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} ==
     * 'virtualMachines/MyVirtualMachine', {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A
     * convenient alternative to providing the namespace and type name separately is to provide both in the
     * {resourceType} parameter, format: ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType}
     * == 'Microsoft.Web/sites', {resourceName} == 'MyWebApp').
     *
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     *     machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForResourceSinglePageAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listForResource(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            resourceProviderNamespace,
                            parentResourcePath,
                            resourceType,
                            resourceName,
                            filter,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<PolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()'
     * or 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource, including those that apply directly or from all containing scopes, as
     * well as any applied to resources contained within the resource. If $filter=atScope() is provided, the returned
     * list includes all policy assignments that apply to the resource, which is everything in the unfiltered list
     * except those applied to resources contained within the resource. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value} that
     * apply to the resource. Three parameters plus the resource name are used to identify a specific resource. If the
     * resource is not part of a parent resource (the more common case), the parent resource path should not be provided
     * (or provided as ''). For example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web',
     * {parentResourcePath} == '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of
     * a parent resource, then all parameters should be provided. For example a virtual machine DNS name could be
     * specified as ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} ==
     * 'virtualMachines/MyVirtualMachine', {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A
     * convenient alternative to providing the namespace and type name separately is to provide both in the
     * {resourceType} parameter, format: ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType}
     * == 'Microsoft.Web/sites', {resourceName} == 'MyWebApp').
     *
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     *     machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForResourceSinglePageAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listForResource(
                this.client.getEndpoint(),
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                filter,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()'
     * or 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource, including those that apply directly or from all containing scopes, as
     * well as any applied to resources contained within the resource. If $filter=atScope() is provided, the returned
     * list includes all policy assignments that apply to the resource, which is everything in the unfiltered list
     * except those applied to resources contained within the resource. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value} that
     * apply to the resource. Three parameters plus the resource name are used to identify a specific resource. If the
     * resource is not part of a parent resource (the more common case), the parent resource path should not be provided
     * (or provided as ''). For example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web',
     * {parentResourcePath} == '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of
     * a parent resource, then all parameters should be provided. For example a virtual machine DNS name could be
     * specified as ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} ==
     * 'virtualMachines/MyVirtualMachine', {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A
     * convenient alternative to providing the namespace and type name separately is to provide both in the
     * {resourceType} parameter, format: ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType}
     * == 'Microsoft.Web/sites', {resourceName} == 'MyWebApp').
     *
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     *     machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter) {
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter),
            nextLink -> listForResourceNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()'
     * or 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource, including those that apply directly or from all containing scopes, as
     * well as any applied to resources contained within the resource. If $filter=atScope() is provided, the returned
     * list includes all policy assignments that apply to the resource, which is everything in the unfiltered list
     * except those applied to resources contained within the resource. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value} that
     * apply to the resource. Three parameters plus the resource name are used to identify a specific resource. If the
     * resource is not part of a parent resource (the more common case), the parent resource path should not be provided
     * (or provided as ''). For example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web',
     * {parentResourcePath} == '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of
     * a parent resource, then all parameters should be provided. For example a virtual machine DNS name could be
     * specified as ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} ==
     * 'virtualMachines/MyVirtualMachine', {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A
     * convenient alternative to providing the namespace and type name separately is to provide both in the
     * {resourceType} parameter, format: ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType}
     * == 'Microsoft.Web/sites', {resourceName} == 'MyWebApp').
     *
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     *     machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName) {
        final String filter = null;
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter),
            nextLink -> listForResourceNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()'
     * or 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource, including those that apply directly or from all containing scopes, as
     * well as any applied to resources contained within the resource. If $filter=atScope() is provided, the returned
     * list includes all policy assignments that apply to the resource, which is everything in the unfiltered list
     * except those applied to resources contained within the resource. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value} that
     * apply to the resource. Three parameters plus the resource name are used to identify a specific resource. If the
     * resource is not part of a parent resource (the more common case), the parent resource path should not be provided
     * (or provided as ''). For example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web',
     * {parentResourcePath} == '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of
     * a parent resource, then all parameters should be provided. For example a virtual machine DNS name could be
     * specified as ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} ==
     * 'virtualMachines/MyVirtualMachine', {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A
     * convenient alternative to providing the namespace and type name separately is to provide both in the
     * {resourceType} parameter, format: ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType}
     * == 'Microsoft.Web/sites', {resourceName} == 'MyWebApp').
     *
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     *     machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicyAssignmentInner> listForResourceAsync(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        return new PagedFlux<>(
            () ->
                listForResourceSinglePageAsync(
                    resourceGroupName,
                    resourceProviderNamespace,
                    parentResourcePath,
                    resourceType,
                    resourceName,
                    filter,
                    context),
            nextLink -> listForResourceNextSinglePageAsync(nextLink, context));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()'
     * or 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource, including those that apply directly or from all containing scopes, as
     * well as any applied to resources contained within the resource. If $filter=atScope() is provided, the returned
     * list includes all policy assignments that apply to the resource, which is everything in the unfiltered list
     * except those applied to resources contained within the resource. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value} that
     * apply to the resource. Three parameters plus the resource name are used to identify a specific resource. If the
     * resource is not part of a parent resource (the more common case), the parent resource path should not be provided
     * (or provided as ''). For example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web',
     * {parentResourcePath} == '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of
     * a parent resource, then all parameters should be provided. For example a virtual machine DNS name could be
     * specified as ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} ==
     * 'virtualMachines/MyVirtualMachine', {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A
     * convenient alternative to providing the namespace and type name separately is to provide both in the
     * {resourceType} parameter, format: ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType}
     * == 'Microsoft.Web/sites', {resourceName} == 'MyWebApp').
     *
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     *     machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyAssignmentInner> listForResource(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName,
        String filter,
        Context context) {
        return new PagedIterable<>(
            listForResourceAsync(
                resourceGroupName,
                resourceProviderNamespace,
                parentResourcePath,
                resourceType,
                resourceName,
                filter,
                context));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()'
     * or 'policyDefinitionId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy
     * assignments associated with the resource, including those that apply directly or from all containing scopes, as
     * well as any applied to resources contained within the resource. If $filter=atScope() is provided, the returned
     * list includes all policy assignments that apply to the resource, which is everything in the unfiltered list
     * except those applied to resources contained within the resource. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value} that
     * apply to the resource. Three parameters plus the resource name are used to identify a specific resource. If the
     * resource is not part of a parent resource (the more common case), the parent resource path should not be provided
     * (or provided as ''). For example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web',
     * {parentResourcePath} == '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of
     * a parent resource, then all parameters should be provided. For example a virtual machine DNS name could be
     * specified as ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} ==
     * 'virtualMachines/MyVirtualMachine', {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A
     * convenient alternative to providing the namespace and type name separately is to provide both in the
     * {resourceType} parameter, format: ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType}
     * == 'Microsoft.Web/sites', {resourceName} == 'MyWebApp').
     *
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     *     machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     *     Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyAssignmentInner> listForResource(
        String resourceGroupName,
        String resourceProviderNamespace,
        String parentResourcePath,
        String resourceType,
        String resourceName) {
        final String filter = null;
        return new PagedIterable<>(
            listForResourceAsync(
                resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter));
    }

    /**
     * This operation retrieves the list of all policy assignments applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter=atScope() is provided, the returned list includes all policy assignments that are assigned to the
     * management group or the management group's ancestors. If $filter=policyDefinitionId eq '{value}' is provided, the
     * returned list includes all policy assignments of the policy definition whose id is {value} that apply to the
     * management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. A filter is required when listing policy assignments at management group
     *     scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForManagementGroupSinglePageAsync(
        String managementGroupId, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listForManagementGroup(
                            this.client.getEndpoint(), managementGroupId, filter, this.client.getApiVersion(), context))
            .<PagedResponse<PolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves the list of all policy assignments applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter=atScope() is provided, the returned list includes all policy assignments that are assigned to the
     * management group or the management group's ancestors. If $filter=policyDefinitionId eq '{value}' is provided, the
     * returned list includes all policy assignments of the policy definition whose id is {value} that apply to the
     * management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. A filter is required when listing policy assignments at management group
     *     scope.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForManagementGroupSinglePageAsync(
        String managementGroupId, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error(new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listForManagementGroup(
                this.client.getEndpoint(), managementGroupId, filter, this.client.getApiVersion(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * This operation retrieves the list of all policy assignments applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter=atScope() is provided, the returned list includes all policy assignments that are assigned to the
     * management group or the management group's ancestors. If $filter=policyDefinitionId eq '{value}' is provided, the
     * returned list includes all policy assignments of the policy definition whose id is {value} that apply to the
     * management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. A filter is required when listing policy assignments at management group
     *     scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyAssignmentInner> listForManagementGroupAsync(String managementGroupId, String filter) {
        return new PagedFlux<>(
            () -> listForManagementGroupSinglePageAsync(managementGroupId, filter),
            nextLink -> listForManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves the list of all policy assignments applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter=atScope() is provided, the returned list includes all policy assignments that are assigned to the
     * management group or the management group's ancestors. If $filter=policyDefinitionId eq '{value}' is provided, the
     * returned list includes all policy assignments of the policy definition whose id is {value} that apply to the
     * management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. A filter is required when listing policy assignments at management group
     *     scope.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicyAssignmentInner> listForManagementGroupAsync(
        String managementGroupId, String filter, Context context) {
        return new PagedFlux<>(
            () -> listForManagementGroupSinglePageAsync(managementGroupId, filter, context),
            nextLink -> listForManagementGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * This operation retrieves the list of all policy assignments applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter=atScope() is provided, the returned list includes all policy assignments that are assigned to the
     * management group or the management group's ancestors. If $filter=policyDefinitionId eq '{value}' is provided, the
     * returned list includes all policy assignments of the policy definition whose id is {value} that apply to the
     * management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. A filter is required when listing policy assignments at management group
     *     scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyAssignmentInner> listForManagementGroup(String managementGroupId, String filter) {
        return new PagedIterable<>(listForManagementGroupAsync(managementGroupId, filter));
    }

    /**
     * This operation retrieves the list of all policy assignments applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter=atScope() is provided, the returned list includes all policy assignments that are assigned to the
     * management group or the management group's ancestors. If $filter=policyDefinitionId eq '{value}' is provided, the
     * returned list includes all policy assignments of the policy definition whose id is {value} that apply to the
     * management group.
     *
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. A filter is required when listing policy assignments at management group
     *     scope.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyAssignmentInner> listForManagementGroup(
        String managementGroupId, String filter, Context context) {
        return new PagedIterable<>(listForManagementGroupAsync(managementGroupId, filter, context));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter is not provided, the unfiltered list includes all policy assignments associated with the subscription,
     * including those that apply directly or from management groups that contain the given subscription, as well as any
     * applied to objects contained within the subscription. If $filter=atScope() is provided, the returned list
     * includes all policy assignments that apply to the subscription, which is everything in the unfiltered list except
     * those applied to objects contained within the subscription. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            filter,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            context))
            .<PagedResponse<PolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter is not provided, the unfiltered list includes all policy assignments associated with the subscription,
     * including those that apply directly or from management groups that contain the given subscription, as well as any
     * applied to objects contained within the subscription. If $filter=atScope() is provided, the returned list
     * includes all policy assignments that apply to the subscription, which is everything in the unfiltered list except
     * those applied to objects contained within the subscription. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                filter,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter is not provided, the unfiltered list includes all policy assignments associated with the subscription,
     * including those that apply directly or from management groups that contain the given subscription, as well as any
     * applied to objects contained within the subscription. If $filter=atScope() is provided, the returned list
     * includes all policy assignments that apply to the subscription, which is everything in the unfiltered list except
     * those applied to objects contained within the subscription. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyAssignmentInner> listAsync(String filter) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter is not provided, the unfiltered list includes all policy assignments associated with the subscription,
     * including those that apply directly or from management groups that contain the given subscription, as well as any
     * applied to objects contained within the subscription. If $filter=atScope() is provided, the returned list
     * includes all policy assignments that apply to the subscription, which is everything in the unfiltered list except
     * those applied to objects contained within the subscription. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value}.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyAssignmentInner> listAsync() {
        final String filter = null;
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter is not provided, the unfiltered list includes all policy assignments associated with the subscription,
     * including those that apply directly or from management groups that contain the given subscription, as well as any
     * applied to objects contained within the subscription. If $filter=atScope() is provided, the returned list
     * includes all policy assignments that apply to the subscription, which is everything in the unfiltered list except
     * those applied to objects contained within the subscription. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicyAssignmentInner> listAsync(String filter, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(filter, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter is not provided, the unfiltered list includes all policy assignments associated with the subscription,
     * including those that apply directly or from management groups that contain the given subscription, as well as any
     * applied to objects contained within the subscription. If $filter=atScope() is provided, the returned list
     * includes all policy assignments that apply to the subscription, which is everything in the unfiltered list except
     * those applied to objects contained within the subscription. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value}.
     *
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()' or
     *     'policyDefinitionId eq '{value}''. If $filter is not provided, no filtering is performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyAssignmentInner> list(String filter, Context context) {
        return new PagedIterable<>(listAsync(filter, context));
    }

    /**
     * This operation retrieves the list of all policy assignments associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()' or 'policyDefinitionId eq '{value}''. If
     * $filter is not provided, the unfiltered list includes all policy assignments associated with the subscription,
     * including those that apply directly or from management groups that contain the given subscription, as well as any
     * applied to objects contained within the subscription. If $filter=atScope() is provided, the returned list
     * includes all policy assignments that apply to the subscription, which is everything in the unfiltered list except
     * those applied to objects contained within the subscription. If $filter=policyDefinitionId eq '{value}' is
     * provided, the returned list includes all policy assignments of the policy definition whose id is {value}.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyAssignmentInner> list() {
        final String filter = null;
        return new PagedIterable<>(listAsync(filter));
    }

    /**
     * This operation deletes the policy with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid formats for {scope}
     * are: '/providers/Microsoft.Management/managementGroups/{managementGroup}' (management group),
     * '/subscriptions/{subscriptionId}' (subscription),
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' (resource group), or
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * (resource).
     *
     * @param policyAssignmentId The ID of the policy assignment to delete. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyAssignmentInner>> deleteByIdWithResponseAsync(String policyAssignmentId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteById(
                            this.client.getEndpoint(), policyAssignmentId, this.client.getApiVersion(), context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation deletes the policy with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid formats for {scope}
     * are: '/providers/Microsoft.Management/managementGroups/{managementGroup}' (management group),
     * '/subscriptions/{subscriptionId}' (subscription),
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' (resource group), or
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * (resource).
     *
     * @param policyAssignmentId The ID of the policy assignment to delete. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyAssignmentInner>> deleteByIdWithResponseAsync(
        String policyAssignmentId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteById(this.client.getEndpoint(), policyAssignmentId, this.client.getApiVersion(), context);
    }

    /**
     * This operation deletes the policy with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid formats for {scope}
     * are: '/providers/Microsoft.Management/managementGroups/{managementGroup}' (management group),
     * '/subscriptions/{subscriptionId}' (subscription),
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' (resource group), or
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * (resource).
     *
     * @param policyAssignmentId The ID of the policy assignment to delete. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyAssignmentInner> deleteByIdAsync(String policyAssignmentId) {
        return deleteByIdWithResponseAsync(policyAssignmentId)
            .flatMap(
                (Response<PolicyAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation deletes the policy with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid formats for {scope}
     * are: '/providers/Microsoft.Management/managementGroups/{managementGroup}' (management group),
     * '/subscriptions/{subscriptionId}' (subscription),
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' (resource group), or
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * (resource).
     *
     * @param policyAssignmentId The ID of the policy assignment to delete. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyAssignmentInner deleteById(String policyAssignmentId) {
        return deleteByIdAsync(policyAssignmentId).block();
    }

    /**
     * This operation deletes the policy with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid formats for {scope}
     * are: '/providers/Microsoft.Management/managementGroups/{managementGroup}' (management group),
     * '/subscriptions/{subscriptionId}' (subscription),
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' (resource group), or
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     * (resource).
     *
     * @param policyAssignmentId The ID of the policy assignment to delete. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyAssignmentInner> deleteByIdWithResponse(String policyAssignmentId, Context context) {
        return deleteByIdWithResponseAsync(policyAssignmentId, context).block();
    }

    /**
     * This operation creates or updates the policy assignment with the given ID. Policy assignments made on a scope
     * apply to all resources contained in that scope. For example, when you assign a policy to a resource group that
     * policy applies to all resources in the group. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to create. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param parameters The policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyAssignmentInner>> createByIdWithResponseAsync(
        String policyAssignmentId, PolicyAssignmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createById(
                            this.client.getEndpoint(),
                            policyAssignmentId,
                            this.client.getApiVersion(),
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * This operation creates or updates the policy assignment with the given ID. Policy assignments made on a scope
     * apply to all resources contained in that scope. For example, when you assign a policy to a resource group that
     * policy applies to all resources in the group. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to create. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param parameters The policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyAssignmentInner>> createByIdWithResponseAsync(
        String policyAssignmentId, PolicyAssignmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        context = this.client.mergeContext(context);
        return service
            .createById(
                this.client.getEndpoint(), policyAssignmentId, this.client.getApiVersion(), parameters, context);
    }

    /**
     * This operation creates or updates the policy assignment with the given ID. Policy assignments made on a scope
     * apply to all resources contained in that scope. For example, when you assign a policy to a resource group that
     * policy applies to all resources in the group. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to create. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param parameters The policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyAssignmentInner> createByIdAsync(String policyAssignmentId, PolicyAssignmentInner parameters) {
        return createByIdWithResponseAsync(policyAssignmentId, parameters)
            .flatMap(
                (Response<PolicyAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation creates or updates the policy assignment with the given ID. Policy assignments made on a scope
     * apply to all resources contained in that scope. For example, when you assign a policy to a resource group that
     * policy applies to all resources in the group. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to create. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param parameters The policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyAssignmentInner createById(String policyAssignmentId, PolicyAssignmentInner parameters) {
        return createByIdAsync(policyAssignmentId, parameters).block();
    }

    /**
     * This operation creates or updates the policy assignment with the given ID. Policy assignments made on a scope
     * apply to all resources contained in that scope. For example, when you assign a policy to a resource group that
     * policy applies to all resources in the group. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to create. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param parameters The policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyAssignmentInner> createByIdWithResponse(
        String policyAssignmentId, PolicyAssignmentInner parameters, Context context) {
        return createByIdWithResponseAsync(policyAssignmentId, parameters, context).block();
    }

    /**
     * The operation retrieves the policy assignment with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to get. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyAssignmentInner>> getByIdWithResponseAsync(String policyAssignmentId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getById(this.client.getEndpoint(), policyAssignmentId, this.client.getApiVersion(), context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * The operation retrieves the policy assignment with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to get. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyAssignmentInner>> getByIdWithResponseAsync(String policyAssignmentId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyAssignmentId is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.getById(this.client.getEndpoint(), policyAssignmentId, this.client.getApiVersion(), context);
    }

    /**
     * The operation retrieves the policy assignment with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to get. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyAssignmentInner> getByIdAsync(String policyAssignmentId) {
        return getByIdWithResponseAsync(policyAssignmentId)
            .flatMap(
                (Response<PolicyAssignmentInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * The operation retrieves the policy assignment with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to get. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyAssignmentInner getById(String policyAssignmentId) {
        return getByIdAsync(policyAssignmentId).block();
    }

    /**
     * The operation retrieves the policy assignment with the given ID. Policy assignment IDs have this format:
     * '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'. Valid scopes are:
     * management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
     * (format: '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     *
     * @param policyAssignmentId The ID of the policy assignment to get. Use the format
     *     '{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyAssignmentInner> getByIdWithResponse(String policyAssignmentId, Context context) {
        return getByIdWithResponseAsync(policyAssignmentId, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listForResourceGroupNext(nextLink, context))
            .<PagedResponse<PolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForResourceGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listForResourceGroupNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listForResourceNext(nextLink, context))
            .<PagedResponse<PolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForResourceNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listForResourceNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listForManagementGroupNext(nextLink, context))
            .<PagedResponse<PolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listForManagementGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listForManagementGroupNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, context))
            .<PagedResponse<PolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy assignments.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyAssignmentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
