/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluent.PolicyDefinitionsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicyDefinitionInner;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.models.PolicyDefinition;
import com.azure.resourcemanager.resources.models.PolicyType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import reactor.core.publisher.Mono;

final class PolicyDefinitionImpl
extends CreatableUpdatableImpl<PolicyDefinition, PolicyDefinitionInner, PolicyDefinitionImpl>
implements PolicyDefinition,
PolicyDefinition.Definition,
PolicyDefinition.Update {
    private final PolicyDefinitionsClient innerCollection;
    private final ClientLogger logger = new ClientLogger(this.getClass());

    PolicyDefinitionImpl(String name, PolicyDefinitionInner innerModel, PolicyDefinitionsClient innerCollection) {
        super(name, innerModel);
        this.innerCollection = innerCollection;
    }

    @Override
    public PolicyType policyType() {
        return ((PolicyDefinitionInner)((Object)this.innerModel())).policyType();
    }

    @Override
    public String displayName() {
        return ((PolicyDefinitionInner)((Object)this.innerModel())).displayName();
    }

    @Override
    public String description() {
        return ((PolicyDefinitionInner)((Object)this.innerModel())).description();
    }

    @Override
    public Object policyRule() {
        return ((PolicyDefinitionInner)((Object)this.innerModel())).policyRule();
    }

    @Override
    public String id() {
        return ((PolicyDefinitionInner)((Object)this.innerModel())).id();
    }

    @Override
    protected Mono<PolicyDefinitionInner> getInnerAsync() {
        return this.innerCollection.getAsync(this.name());
    }

    @Override
    public PolicyDefinitionImpl withDescription(String description) {
        ((PolicyDefinitionInner)((Object)this.innerModel())).withDescription(description);
        return this;
    }

    @Override
    public PolicyDefinitionImpl withDisplayName(String displayName) {
        ((PolicyDefinitionInner)((Object)this.innerModel())).withDisplayName(displayName);
        return this;
    }

    @Override
    public PolicyDefinitionImpl withPolicyRule(Object policyRule) {
        ((PolicyDefinitionInner)((Object)this.innerModel())).withPolicyRule(policyRule);
        return this;
    }

    @Override
    public PolicyDefinitionImpl withPolicyRuleJson(String policyRuleJson) {
        try {
            ((PolicyDefinitionInner)((Object)this.innerModel())).withPolicyRule(new ObjectMapper().readTree(policyRuleJson));
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        return this;
    }

    @Override
    public PolicyDefinitionImpl withPolicyType(PolicyType policyType) {
        ((PolicyDefinitionInner)((Object)this.innerModel())).withPolicyType(policyType);
        return this;
    }

    @Override
    public Mono<PolicyDefinition> createResourceAsync() {
        return this.innerCollection.createOrUpdateAsync(this.name(), (PolicyDefinitionInner)((Object)this.innerModel())).map(this.innerToFluentMap(this));
    }

    @Override
    public boolean isInCreateMode() {
        return this.id() == null;
    }
}

