// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.resourcemanager.resources.models.AzureResourceBase;
import com.azure.resourcemanager.resources.models.DeploymentStackValidateProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The Deployment stack validation result.
 */
@Fluent
public final class DeploymentStackValidateResultInner extends AzureResourceBase {
    /*
     * The validation result details.
     */
    @JsonProperty(value = "properties")
    private DeploymentStackValidateProperties properties;

    /*
     * The error detail.
     */
    @JsonProperty(value = "error")
    private ManagementError error;

    /**
     * Creates an instance of DeploymentStackValidateResultInner class.
     */
    public DeploymentStackValidateResultInner() {
    }

    /**
     * Get the properties property: The validation result details.
     * 
     * @return the properties value.
     */
    public DeploymentStackValidateProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The validation result details.
     * 
     * @param properties the properties value to set.
     * @return the DeploymentStackValidateResultInner object itself.
     */
    public DeploymentStackValidateResultInner withProperties(DeploymentStackValidateProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the error property: The error detail.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The error detail.
     * 
     * @param error the error value to set.
     * @return the DeploymentStackValidateResultInner object itself.
     */
    public DeploymentStackValidateResultInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() != null) {
            properties().validate();
        }
    }
}
