// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.Tags;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Wrapper resource for tags API requests and responses.
 */
@Fluent
public final class TagsResourceInner extends ProxyResource {
    /*
     * The set of tags.
     */
    @JsonProperty(value = "properties", required = true)
    private Tags properties;

    /**
     * Creates an instance of TagsResourceInner class.
     */
    public TagsResourceInner() {
    }

    /**
     * Get the properties property: The set of tags.
     * 
     * @return the properties value.
     */
    public Tags properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The set of tags.
     * 
     * @param properties the properties value to set.
     * @return the TagsResourceInner object itself.
     */
    public TagsResourceInner withProperties(Tags properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property properties in model TagsResourceInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TagsResourceInner.class);
}
