// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.resources.fluent.PolicyExemptionsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicyExemptionInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.models.PolicyExemptionListResult;
import com.azure.resourcemanager.resources.models.PolicyExemptionUpdate;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PolicyExemptionsClient.
 */
public final class PolicyExemptionsClientImpl
    implements InnerSupportsListing<PolicyExemptionInner>, InnerSupportsDelete<Void>, PolicyExemptionsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final PolicyExemptionsService service;

    /**
     * The service client containing this operation class.
     */
    private final PolicyClientImpl client;

    /**
     * Initializes an instance of PolicyExemptionsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    PolicyExemptionsClientImpl(PolicyClientImpl client) {
        this.service
            = RestProxy.create(PolicyExemptionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PolicyClientPolicyExemptions to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PolicyClientPolicyEx")
    public interface PolicyExemptionsService {
        @Headers({ "Content-Type: application/json" })
        @Delete("/{scope}/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("policyExemptionName") String policyExemptionName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/{scope}/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("policyExemptionName") String policyExemptionName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PolicyExemptionInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionInner>> get(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("policyExemptionName") String policyExemptionName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/{scope}/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionInner>> update(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("policyExemptionName") String policyExemptionName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PolicyExemptionUpdate parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyExemptions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam(value = "$filter", encoded = true) String filter, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/policyExemptions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionListResult>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam(value = "$filter", encoded = true) String filter, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/policyExemptions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionListResult>> listForResource(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceProviderNamespace") String resourceProviderNamespace,
            @PathParam(value = "parentResourcePath", encoded = true) String parentResourcePath,
            @PathParam(value = "resourceType", encoded = true) String resourceType,
            @PathParam("resourceName") String resourceName,
            @QueryParam(value = "$filter", encoded = true) String filter, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policyExemptions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionListResult>> listForManagementGroup(@HostParam("$host") String endpoint,
            @PathParam("managementGroupId") String managementGroupId,
            @QueryParam(value = "$filter", encoded = true) String filter, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionListResult>> listForResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionListResult>> listForResourceNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicyExemptionListResult>> listForManagementGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Deletes a policy exemption.
     * 
     * This operation deletes a policy exemption, given its name and the scope it was created in. The scope of a policy
     * exemption is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}'.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String scope, String policyExemptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyExemptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyExemptionName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), scope, policyExemptionName, apiVersion,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a policy exemption.
     * 
     * This operation deletes a policy exemption, given its name and the scope it was created in. The scope of a policy
     * exemption is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}'.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String scope, String policyExemptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyExemptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyExemptionName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), scope, policyExemptionName, apiVersion, accept, context);
    }

    /**
     * Deletes a policy exemption.
     * 
     * This operation deletes a policy exemption, given its name and the scope it was created in. The scope of a policy
     * exemption is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}'.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String scope, String policyExemptionName) {
        return deleteWithResponseAsync(scope, policyExemptionName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a policy exemption.
     * 
     * This operation deletes a policy exemption, given its name and the scope it was created in. The scope of a policy
     * exemption is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}'.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String scope, String policyExemptionName, Context context) {
        return deleteWithResponseAsync(scope, policyExemptionName, context).block();
    }

    /**
     * Deletes a policy exemption.
     * 
     * This operation deletes a policy exemption, given its name and the scope it was created in. The scope of a policy
     * exemption is the part of its ID preceding
     * '/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}'.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String scope, String policyExemptionName) {
        deleteWithResponse(scope, policyExemptionName, Context.NONE);
    }

    /**
     * Creates or updates a policy exemption.
     * 
     * This operation creates or updates a policy exemption with the given scope and name. Policy exemptions apply to
     * all resources contained within their scope. For example, when you create a policy exemption at resource group
     * scope for a policy assignment at the same or above level, the exemption exempts to all applicable resources in
     * the resource group.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for the policy exemption.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyExemptionInner>> createOrUpdateWithResponseAsync(String scope,
        String policyExemptionName, PolicyExemptionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyExemptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyExemptionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), scope, policyExemptionName,
                apiVersion, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a policy exemption.
     * 
     * This operation creates or updates a policy exemption with the given scope and name. Policy exemptions apply to
     * all resources contained within their scope. For example, when you create a policy exemption at resource group
     * scope for a policy assignment at the same or above level, the exemption exempts to all applicable resources in
     * the resource group.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for the policy exemption.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyExemptionInner>> createOrUpdateWithResponseAsync(String scope,
        String policyExemptionName, PolicyExemptionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyExemptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyExemptionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), scope, policyExemptionName, apiVersion, parameters,
            accept, context);
    }

    /**
     * Creates or updates a policy exemption.
     * 
     * This operation creates or updates a policy exemption with the given scope and name. Policy exemptions apply to
     * all resources contained within their scope. For example, when you create a policy exemption at resource group
     * scope for a policy assignment at the same or above level, the exemption exempts to all applicable resources in
     * the resource group.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for the policy exemption.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyExemptionInner> createOrUpdateAsync(String scope, String policyExemptionName,
        PolicyExemptionInner parameters) {
        return createOrUpdateWithResponseAsync(scope, policyExemptionName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a policy exemption.
     * 
     * This operation creates or updates a policy exemption with the given scope and name. Policy exemptions apply to
     * all resources contained within their scope. For example, when you create a policy exemption at resource group
     * scope for a policy assignment at the same or above level, the exemption exempts to all applicable resources in
     * the resource group.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for the policy exemption.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyExemptionInner> createOrUpdateWithResponse(String scope, String policyExemptionName,
        PolicyExemptionInner parameters, Context context) {
        return createOrUpdateWithResponseAsync(scope, policyExemptionName, parameters, context).block();
    }

    /**
     * Creates or updates a policy exemption.
     * 
     * This operation creates or updates a policy exemption with the given scope and name. Policy exemptions apply to
     * all resources contained within their scope. For example, when you create a policy exemption at resource group
     * scope for a policy assignment at the same or above level, the exemption exempts to all applicable resources in
     * the resource group.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for the policy exemption.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyExemptionInner createOrUpdate(String scope, String policyExemptionName,
        PolicyExemptionInner parameters) {
        return createOrUpdateWithResponse(scope, policyExemptionName, parameters, Context.NONE).getValue();
    }

    /**
     * Retrieves a policy exemption.
     * 
     * This operation retrieves a single policy exemption, given its name and the scope it was created at.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyExemptionInner>> getWithResponseAsync(String scope, String policyExemptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyExemptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyExemptionName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.get(this.client.getEndpoint(), scope, policyExemptionName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves a policy exemption.
     * 
     * This operation retrieves a single policy exemption, given its name and the scope it was created at.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyExemptionInner>> getWithResponseAsync(String scope, String policyExemptionName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyExemptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyExemptionName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), scope, policyExemptionName, apiVersion, accept, context);
    }

    /**
     * Retrieves a policy exemption.
     * 
     * This operation retrieves a single policy exemption, given its name and the scope it was created at.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyExemptionInner> getAsync(String scope, String policyExemptionName) {
        return getWithResponseAsync(scope, policyExemptionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a policy exemption.
     * 
     * This operation retrieves a single policy exemption, given its name and the scope it was created at.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyExemptionInner> getWithResponse(String scope, String policyExemptionName, Context context) {
        return getWithResponseAsync(scope, policyExemptionName, context).block();
    }

    /**
     * Retrieves a policy exemption.
     * 
     * This operation retrieves a single policy exemption, given its name and the scope it was created at.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyExemptionInner get(String scope, String policyExemptionName) {
        return getWithResponse(scope, policyExemptionName, Context.NONE).getValue();
    }

    /**
     * Updates a policy exemption.
     * 
     * This operation updates a policy exemption with the given scope and name.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for policy exemption patch request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicyExemptionInner>> updateWithResponseAsync(String scope, String policyExemptionName,
        PolicyExemptionUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyExemptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyExemptionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), scope, policyExemptionName, apiVersion,
                parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a policy exemption.
     * 
     * This operation updates a policy exemption with the given scope and name.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for policy exemption patch request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicyExemptionInner>> updateWithResponseAsync(String scope, String policyExemptionName,
        PolicyExemptionUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (policyExemptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter policyExemptionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), scope, policyExemptionName, apiVersion, parameters, accept,
            context);
    }

    /**
     * Updates a policy exemption.
     * 
     * This operation updates a policy exemption with the given scope and name.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for policy exemption patch request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicyExemptionInner> updateAsync(String scope, String policyExemptionName,
        PolicyExemptionUpdate parameters) {
        return updateWithResponseAsync(scope, policyExemptionName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates a policy exemption.
     * 
     * This operation updates a policy exemption with the given scope and name.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for policy exemption patch request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicyExemptionInner> updateWithResponse(String scope, String policyExemptionName,
        PolicyExemptionUpdate parameters, Context context) {
        return updateWithResponseAsync(scope, policyExemptionName, parameters, context).block();
    }

    /**
     * Updates a policy exemption.
     * 
     * This operation updates a policy exemption with the given scope and name.
     * 
     * @param scope The scope of the policy exemption. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'.
     * @param policyExemptionName The name of the policy exemption to delete.
     * @param parameters Parameters for policy exemption patch request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy exemption.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicyExemptionInner update(String scope, String policyExemptionName, PolicyExemptionUpdate parameters) {
        return updateWithResponse(scope, policyExemptionName, parameters, Context.NONE).getValue();
    }

    /**
     * Retrieves all policy exemptions that apply to a subscription.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy exemptions
     * associated with the subscription, including those that apply directly or from management groups that contain the
     * given subscription, as well as any applied to objects contained within the subscription.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), filter,
                apiVersion, accept, context))
            .<PagedResponse<PolicyExemptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all policy exemptions that apply to a subscription.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy exemptions
     * associated with the subscription, including those that apply directly or from management groups that contain the
     * given subscription, as well as any applied to objects contained within the subscription.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), filter, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Retrieves all policy exemptions that apply to a subscription.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy exemptions
     * associated with the subscription, including those that apply directly or from management groups that contain the
     * given subscription, as well as any applied to objects contained within the subscription.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyExemptionInner> listAsync(String filter) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy exemptions that apply to a subscription.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy exemptions
     * associated with the subscription, including those that apply directly or from management groups that contain the
     * given subscription, as well as any applied to objects contained within the subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyExemptionInner> listAsync() {
        final String filter = null;
        return new PagedFlux<>(() -> listSinglePageAsync(filter), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy exemptions that apply to a subscription.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy exemptions
     * associated with the subscription, including those that apply directly or from management groups that contain the
     * given subscription, as well as any applied to objects contained within the subscription.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicyExemptionInner> listAsync(String filter, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all policy exemptions that apply to a subscription.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy exemptions
     * associated with the subscription, including those that apply directly or from management groups that contain the
     * given subscription, as well as any applied to objects contained within the subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyExemptionInner> list() {
        final String filter = null;
        return new PagedIterable<>(listAsync(filter));
    }

    /**
     * Retrieves all policy exemptions that apply to a subscription.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given subscription that match the
     * optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes all policy exemptions
     * associated with the subscription, including those that apply directly or from management groups that contain the
     * given subscription, as well as any applied to objects contained within the subscription.
     * 
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyExemptionInner> list(String filter, Context context) {
        return new PagedIterable<>(listAsync(filter, context));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource group.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes
     * all policy exemptions associated with the resource group, including those that apply directly or apply from
     * containing scopes, as well as any applied to resources contained within the resource group.
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, filter, apiVersion, accept, context))
            .<PagedResponse<PolicyExemptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource group.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes
     * all policy exemptions associated with the resource group, including those that apply directly or apply from
     * containing scopes, as well as any applied to resources contained within the resource group.
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, filter,
                apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource group.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes
     * all policy exemptions associated with the resource group, including those that apply directly or apply from
     * containing scopes, as well as any applied to resources contained within the resource group.
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyExemptionInner> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource group.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes
     * all policy exemptions associated with the resource group, including those that apply directly or apply from
     * containing scopes, as well as any applied to resources contained within the resource group.
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyExemptionInner> listByResourceGroupAsync(String resourceGroupName) {
        final String filter = null;
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, filter),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource group.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes
     * all policy exemptions associated with the resource group, including those that apply directly or apply from
     * containing scopes, as well as any applied to resources contained within the resource group.
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicyExemptionInner> listByResourceGroupAsync(String resourceGroupName, String filter,
        Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, context),
            nextLink -> listForResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource group.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes
     * all policy exemptions associated with the resource group, including those that apply directly or apply from
     * containing scopes, as well as any applied to resources contained within the resource group.
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyExemptionInner> listByResourceGroup(String resourceGroupName) {
        final String filter = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource group.
     * 
     * This operation retrieves the list of all policy exemptions associated with the given resource group in the given
     * subscription that match the optional given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the unfiltered list includes
     * all policy exemptions associated with the resource group, including those that apply directly or apply from
     * containing scopes, as well as any applied to resources contained within the resource group.
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyExemptionInner> listByResourceGroup(String resourceGroupName, String filter,
        Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter, context));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource.
     * 
     * This operation retrieves the list of all policy exemptions associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()',
     * 'atExactScope()', 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the
     * unfiltered list includes all policy exemptions associated with the resource, including those that apply directly
     * or from all containing scopes, as well as any applied to resources contained within the resource. Three
     * parameters plus the resource name are used to identify a specific resource. If the resource is not part of a
     * parent resource (the more common case), the parent resource path should not be provided (or provided as ''). For
     * example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web', {parentResourcePath} ==
     * '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of a parent resource, then
     * all parameters should be provided. For example a virtual machine DNS name could be specified as
     * ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} == 'virtualMachines/MyVirtualMachine',
     * {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A convenient alternative to providing the
     * namespace and type name separately is to provide both in the {resourceType} parameter, format:
     * ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType} == 'Microsoft.Web/sites',
     * {resourceName} == 'MyWebApp').
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     * machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     * Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForResourceSinglePageAsync(String resourceGroupName,
        String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName,
        String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForResource(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter,
                apiVersion, accept, context))
            .<PagedResponse<PolicyExemptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource.
     * 
     * This operation retrieves the list of all policy exemptions associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()',
     * 'atExactScope()', 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the
     * unfiltered list includes all policy exemptions associated with the resource, including those that apply directly
     * or from all containing scopes, as well as any applied to resources contained within the resource. Three
     * parameters plus the resource name are used to identify a specific resource. If the resource is not part of a
     * parent resource (the more common case), the parent resource path should not be provided (or provided as ''). For
     * example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web', {parentResourcePath} ==
     * '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of a parent resource, then
     * all parameters should be provided. For example a virtual machine DNS name could be specified as
     * ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} == 'virtualMachines/MyVirtualMachine',
     * {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A convenient alternative to providing the
     * namespace and type name separately is to provide both in the {resourceType} parameter, format:
     * ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType} == 'Microsoft.Web/sites',
     * {resourceName} == 'MyWebApp').
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     * machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     * Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForResourceSinglePageAsync(String resourceGroupName,
        String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName,
        String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForResource(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter, apiVersion, accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource.
     * 
     * This operation retrieves the list of all policy exemptions associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()',
     * 'atExactScope()', 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the
     * unfiltered list includes all policy exemptions associated with the resource, including those that apply directly
     * or from all containing scopes, as well as any applied to resources contained within the resource. Three
     * parameters plus the resource name are used to identify a specific resource. If the resource is not part of a
     * parent resource (the more common case), the parent resource path should not be provided (or provided as ''). For
     * example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web', {parentResourcePath} ==
     * '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of a parent resource, then
     * all parameters should be provided. For example a virtual machine DNS name could be specified as
     * ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} == 'virtualMachines/MyVirtualMachine',
     * {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A convenient alternative to providing the
     * namespace and type name separately is to provide both in the {resourceType} parameter, format:
     * ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType} == 'Microsoft.Web/sites',
     * {resourceName} == 'MyWebApp').
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     * machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     * Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyExemptionInner> listForResourceAsync(String resourceGroupName,
        String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName,
        String filter) {
        return new PagedFlux<>(() -> listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace,
            parentResourcePath, resourceType, resourceName, filter),
            nextLink -> listForResourceNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource.
     * 
     * This operation retrieves the list of all policy exemptions associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()',
     * 'atExactScope()', 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the
     * unfiltered list includes all policy exemptions associated with the resource, including those that apply directly
     * or from all containing scopes, as well as any applied to resources contained within the resource. Three
     * parameters plus the resource name are used to identify a specific resource. If the resource is not part of a
     * parent resource (the more common case), the parent resource path should not be provided (or provided as ''). For
     * example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web', {parentResourcePath} ==
     * '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of a parent resource, then
     * all parameters should be provided. For example a virtual machine DNS name could be specified as
     * ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} == 'virtualMachines/MyVirtualMachine',
     * {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A convenient alternative to providing the
     * namespace and type name separately is to provide both in the {resourceType} parameter, format:
     * ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType} == 'Microsoft.Web/sites',
     * {resourceName} == 'MyWebApp').
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     * machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     * Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyExemptionInner> listForResourceAsync(String resourceGroupName,
        String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        final String filter = null;
        return new PagedFlux<>(() -> listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace,
            parentResourcePath, resourceType, resourceName, filter),
            nextLink -> listForResourceNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource.
     * 
     * This operation retrieves the list of all policy exemptions associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()',
     * 'atExactScope()', 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the
     * unfiltered list includes all policy exemptions associated with the resource, including those that apply directly
     * or from all containing scopes, as well as any applied to resources contained within the resource. Three
     * parameters plus the resource name are used to identify a specific resource. If the resource is not part of a
     * parent resource (the more common case), the parent resource path should not be provided (or provided as ''). For
     * example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web', {parentResourcePath} ==
     * '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of a parent resource, then
     * all parameters should be provided. For example a virtual machine DNS name could be specified as
     * ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} == 'virtualMachines/MyVirtualMachine',
     * {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A convenient alternative to providing the
     * namespace and type name separately is to provide both in the {resourceType} parameter, format:
     * ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType} == 'Microsoft.Web/sites',
     * {resourceName} == 'MyWebApp').
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     * machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     * Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicyExemptionInner> listForResourceAsync(String resourceGroupName,
        String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName,
        String filter, Context context) {
        return new PagedFlux<>(
            () -> listForResourceSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath,
                resourceType, resourceName, filter, context),
            nextLink -> listForResourceNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource.
     * 
     * This operation retrieves the list of all policy exemptions associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()',
     * 'atExactScope()', 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the
     * unfiltered list includes all policy exemptions associated with the resource, including those that apply directly
     * or from all containing scopes, as well as any applied to resources contained within the resource. Three
     * parameters plus the resource name are used to identify a specific resource. If the resource is not part of a
     * parent resource (the more common case), the parent resource path should not be provided (or provided as ''). For
     * example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web', {parentResourcePath} ==
     * '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of a parent resource, then
     * all parameters should be provided. For example a virtual machine DNS name could be specified as
     * ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} == 'virtualMachines/MyVirtualMachine',
     * {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A convenient alternative to providing the
     * namespace and type name separately is to provide both in the {resourceType} parameter, format:
     * ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType} == 'Microsoft.Web/sites',
     * {resourceName} == 'MyWebApp').
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     * machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     * Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyExemptionInner> listForResource(String resourceGroupName,
        String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        final String filter = null;
        return new PagedIterable<>(listForResourceAsync(resourceGroupName, resourceProviderNamespace,
            parentResourcePath, resourceType, resourceName, filter));
    }

    /**
     * Retrieves all policy exemptions that apply to a resource.
     * 
     * This operation retrieves the list of all policy exemptions associated with the specified resource in the given
     * resource group and subscription that match the optional given $filter. Valid values for $filter are: 'atScope()',
     * 'atExactScope()', 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, the
     * unfiltered list includes all policy exemptions associated with the resource, including those that apply directly
     * or from all containing scopes, as well as any applied to resources contained within the resource. Three
     * parameters plus the resource name are used to identify a specific resource. If the resource is not part of a
     * parent resource (the more common case), the parent resource path should not be provided (or provided as ''). For
     * example a web app could be specified as ({resourceProviderNamespace} == 'Microsoft.Web', {parentResourcePath} ==
     * '', {resourceType} == 'sites', {resourceName} == 'MyWebApp'). If the resource is part of a parent resource, then
     * all parameters should be provided. For example a virtual machine DNS name could be specified as
     * ({resourceProviderNamespace} == 'Microsoft.Compute', {parentResourcePath} == 'virtualMachines/MyVirtualMachine',
     * {resourceType} == 'domainNames', {resourceName} == 'MyComputerName'). A convenient alternative to providing the
     * namespace and type name separately is to provide both in the {resourceType} parameter, format:
     * ({resourceProviderNamespace} == '', {parentResourcePath} == '', {resourceType} == 'Microsoft.Web/sites',
     * {resourceName} == 'MyWebApp').
     * 
     * @param resourceGroupName The name of the resource group containing the resource.
     * @param resourceProviderNamespace The namespace of the resource provider. For example, the namespace of a virtual
     * machine is Microsoft.Compute (from Microsoft.Compute/virtualMachines).
     * @param parentResourcePath The parent resource path. Use empty string if there is none.
     * @param resourceType The resource type name. For example the type name of a web app is 'sites' (from
     * Microsoft.Web/sites).
     * @param resourceName The name of the resource.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyExemptionInner> listForResource(String resourceGroupName,
        String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName,
        String filter, Context context) {
        return new PagedIterable<>(listForResourceAsync(resourceGroupName, resourceProviderNamespace,
            parentResourcePath, resourceType, resourceName, filter, context));
    }

    /**
     * Retrieves all policy exemptions that apply to a management group.
     * 
     * This operation retrieves the list of all policy exemptions applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter=atScope() is provided, the returned list includes all policy
     * exemptions that are assigned to the management group or the management group's ancestors.
     * 
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForManagementGroupSinglePageAsync(String managementGroupId,
        String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForManagementGroup(this.client.getEndpoint(), managementGroupId, filter,
                apiVersion, accept, context))
            .<PagedResponse<PolicyExemptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all policy exemptions that apply to a management group.
     * 
     * This operation retrieves the list of all policy exemptions applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter=atScope() is provided, the returned list includes all policy
     * exemptions that are assigned to the management group or the management group's ancestors.
     * 
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForManagementGroupSinglePageAsync(String managementGroupId,
        String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForManagementGroup(this.client.getEndpoint(), managementGroupId, filter, apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Retrieves all policy exemptions that apply to a management group.
     * 
     * This operation retrieves the list of all policy exemptions applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter=atScope() is provided, the returned list includes all policy
     * exemptions that are assigned to the management group or the management group's ancestors.
     * 
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyExemptionInner> listForManagementGroupAsync(String managementGroupId, String filter) {
        return new PagedFlux<>(() -> listForManagementGroupSinglePageAsync(managementGroupId, filter),
            nextLink -> listForManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy exemptions that apply to a management group.
     * 
     * This operation retrieves the list of all policy exemptions applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter=atScope() is provided, the returned list includes all policy
     * exemptions that are assigned to the management group or the management group's ancestors.
     * 
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicyExemptionInner> listForManagementGroupAsync(String managementGroupId) {
        final String filter = null;
        return new PagedFlux<>(() -> listForManagementGroupSinglePageAsync(managementGroupId, filter),
            nextLink -> listForManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy exemptions that apply to a management group.
     * 
     * This operation retrieves the list of all policy exemptions applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter=atScope() is provided, the returned list includes all policy
     * exemptions that are assigned to the management group or the management group's ancestors.
     * 
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicyExemptionInner> listForManagementGroupAsync(String managementGroupId, String filter,
        Context context) {
        return new PagedFlux<>(() -> listForManagementGroupSinglePageAsync(managementGroupId, filter, context),
            nextLink -> listForManagementGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all policy exemptions that apply to a management group.
     * 
     * This operation retrieves the list of all policy exemptions applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter=atScope() is provided, the returned list includes all policy
     * exemptions that are assigned to the management group or the management group's ancestors.
     * 
     * @param managementGroupId The ID of the management group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyExemptionInner> listForManagementGroup(String managementGroupId) {
        final String filter = null;
        return new PagedIterable<>(listForManagementGroupAsync(managementGroupId, filter));
    }

    /**
     * Retrieves all policy exemptions that apply to a management group.
     * 
     * This operation retrieves the list of all policy exemptions applicable to the management group that match the
     * given $filter. Valid values for $filter are: 'atScope()', 'atExactScope()', 'excludeExpired()' or
     * 'policyAssignmentId eq '{value}''. If $filter=atScope() is provided, the returned list includes all policy
     * exemptions that are assigned to the management group or the management group's ancestors.
     * 
     * @param managementGroupId The ID of the management group.
     * @param filter The filter to apply on the operation. Valid values for $filter are: 'atScope()', 'atExactScope()',
     * 'excludeExpired()' or 'policyAssignmentId eq '{value}''. If $filter is not provided, no filtering is performed.
     * If $filter is not provided, the unfiltered list includes all policy exemptions associated with the scope,
     * including those that apply directly or apply from containing scopes. If $filter=atScope() is provided, the
     * returned list only includes all policy exemptions that apply to the scope, which is everything in the unfiltered
     * list except those applied to sub scopes contained within the given scope. If $filter=atExactScope() is provided,
     * the returned list only includes all policy exemptions that at the given scope. If $filter=excludeExpired() is
     * provided, the returned list only includes all policy exemptions that either haven't expired or didn't set
     * expiration date. If $filter=policyAssignmentId eq '{value}' is provided. the returned list only includes all
     * policy exemptions that are associated with the give policyAssignmentId.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicyExemptionInner> listForManagementGroup(String managementGroupId, String filter,
        Context context) {
        return new PagedIterable<>(listForManagementGroupAsync(managementGroupId, filter, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicyExemptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicyExemptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForResourceGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listForResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForResourceNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicyExemptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForResourceNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listForResourceNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listForManagementGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicyExemptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy exemptions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyExemptionInner>> listForManagementGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listForManagementGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
