// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the behavior of resources that are no longer managed after the stack is updated or deleted.
 */
@Fluent
public final class ActionOnUnmanage {
    /*
     * Specifies an action for a newly unmanaged resource. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JsonProperty(value = "resources", required = true)
    private DeploymentStacksDeleteDetachEnum resources;

    /*
     * Specifies an action for a newly unmanaged resource. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JsonProperty(value = "resourceGroups")
    private DeploymentStacksDeleteDetachEnum resourceGroups;

    /*
     * Specifies an action for a newly unmanaged resource. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
     */
    @JsonProperty(value = "managementGroups")
    private DeploymentStacksDeleteDetachEnum managementGroups;

    /**
     * Creates an instance of ActionOnUnmanage class.
     */
    public ActionOnUnmanage() {
    }

    /**
     * Get the resources property: Specifies an action for a newly unmanaged resource. Delete will attempt to delete the
     * resource from Azure. Detach will leave the resource in it's current state.
     * 
     * @return the resources value.
     */
    public DeploymentStacksDeleteDetachEnum resources() {
        return this.resources;
    }

    /**
     * Set the resources property: Specifies an action for a newly unmanaged resource. Delete will attempt to delete the
     * resource from Azure. Detach will leave the resource in it's current state.
     * 
     * @param resources the resources value to set.
     * @return the ActionOnUnmanage object itself.
     */
    public ActionOnUnmanage withResources(DeploymentStacksDeleteDetachEnum resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Get the resourceGroups property: Specifies an action for a newly unmanaged resource. Delete will attempt to
     * delete the resource from Azure. Detach will leave the resource in it's current state.
     * 
     * @return the resourceGroups value.
     */
    public DeploymentStacksDeleteDetachEnum resourceGroups() {
        return this.resourceGroups;
    }

    /**
     * Set the resourceGroups property: Specifies an action for a newly unmanaged resource. Delete will attempt to
     * delete the resource from Azure. Detach will leave the resource in it's current state.
     * 
     * @param resourceGroups the resourceGroups value to set.
     * @return the ActionOnUnmanage object itself.
     */
    public ActionOnUnmanage withResourceGroups(DeploymentStacksDeleteDetachEnum resourceGroups) {
        this.resourceGroups = resourceGroups;
        return this;
    }

    /**
     * Get the managementGroups property: Specifies an action for a newly unmanaged resource. Delete will attempt to
     * delete the resource from Azure. Detach will leave the resource in it's current state.
     * 
     * @return the managementGroups value.
     */
    public DeploymentStacksDeleteDetachEnum managementGroups() {
        return this.managementGroups;
    }

    /**
     * Set the managementGroups property: Specifies an action for a newly unmanaged resource. Delete will attempt to
     * delete the resource from Azure. Detach will leave the resource in it's current state.
     * 
     * @param managementGroups the managementGroups value to set.
     * @return the ActionOnUnmanage object itself.
     */
    public ActionOnUnmanage withManagementGroups(DeploymentStacksDeleteDetachEnum managementGroups) {
        this.managementGroups = managementGroups;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resources() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property resources in model ActionOnUnmanage"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ActionOnUnmanage.class);
}
