// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Defines how resources deployed by the Deployment stack are locked.
 */
@Fluent
public final class DenySettings {
    /*
     * denySettings Mode that defines denied actions.
     */
    @JsonProperty(value = "mode", required = true)
    private DenySettingsMode mode;

    /*
     * List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted.
     */
    @JsonProperty(value = "excludedPrincipals")
    private List<String> excludedPrincipals;

    /*
     * List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*\/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
     */
    @JsonProperty(value = "excludedActions")
    private List<String> excludedActions;

    /*
     * DenySettings will be applied to child resource scopes of every managed resource with a deny assignment.
     */
    @JsonProperty(value = "applyToChildScopes")
    private Boolean applyToChildScopes;

    /**
     * Creates an instance of DenySettings class.
     */
    public DenySettings() {
    }

    /**
     * Get the mode property: denySettings Mode that defines denied actions.
     * 
     * @return the mode value.
     */
    public DenySettingsMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: denySettings Mode that defines denied actions.
     * 
     * @param mode the mode value to set.
     * @return the DenySettings object itself.
     */
    public DenySettings withMode(DenySettingsMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the excludedPrincipals property: List of AAD principal IDs excluded from the lock. Up to 5 principals are
     * permitted.
     * 
     * @return the excludedPrincipals value.
     */
    public List<String> excludedPrincipals() {
        return this.excludedPrincipals;
    }

    /**
     * Set the excludedPrincipals property: List of AAD principal IDs excluded from the lock. Up to 5 principals are
     * permitted.
     * 
     * @param excludedPrincipals the excludedPrincipals value to set.
     * @return the DenySettings object itself.
     */
    public DenySettings withExcludedPrincipals(List<String> excludedPrincipals) {
        this.excludedPrincipals = excludedPrincipals;
        return this;
    }

    /**
     * Get the excludedActions property: List of role-based management operations that are excluded from the
     * denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the
     * following actions are automatically appended to 'excludedActions': '*\/read' and
     * 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following
     * actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate
     * actions will be removed.
     * 
     * @return the excludedActions value.
     */
    public List<String> excludedActions() {
        return this.excludedActions;
    }

    /**
     * Set the excludedActions property: List of role-based management operations that are excluded from the
     * denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the
     * following actions are automatically appended to 'excludedActions': '*\/read' and
     * 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following
     * actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate
     * actions will be removed.
     * 
     * @param excludedActions the excludedActions value to set.
     * @return the DenySettings object itself.
     */
    public DenySettings withExcludedActions(List<String> excludedActions) {
        this.excludedActions = excludedActions;
        return this;
    }

    /**
     * Get the applyToChildScopes property: DenySettings will be applied to child resource scopes of every managed
     * resource with a deny assignment.
     * 
     * @return the applyToChildScopes value.
     */
    public Boolean applyToChildScopes() {
        return this.applyToChildScopes;
    }

    /**
     * Set the applyToChildScopes property: DenySettings will be applied to child resource scopes of every managed
     * resource with a deny assignment.
     * 
     * @param applyToChildScopes the applyToChildScopes value to set.
     * @return the DenySettings object itself.
     */
    public DenySettings withApplyToChildScopes(Boolean applyToChildScopes) {
        this.applyToChildScopes = applyToChildScopes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property mode in model DenySettings"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DenySettings.class);
}
