// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * denySettings Mode that defines denied actions.
 */
public final class DenySettingsMode extends ExpandableStringEnum<DenySettingsMode> {
    /**
     * Static value denyDelete for DenySettingsMode.
     */
    public static final DenySettingsMode DENY_DELETE = fromString("denyDelete");

    /**
     * Static value denyWriteAndDelete for DenySettingsMode.
     */
    public static final DenySettingsMode DENY_WRITE_AND_DELETE = fromString("denyWriteAndDelete");

    /**
     * Static value none for DenySettingsMode.
     */
    public static final DenySettingsMode NONE = fromString("none");

    /**
     * Creates a new instance of DenySettingsMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DenySettingsMode() {
    }

    /**
     * Creates or finds a DenySettingsMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DenySettingsMode.
     */
    @JsonCreator
    public static DenySettingsMode fromString(String name) {
        return fromString(name, DenySettingsMode.class);
    }

    /**
     * Gets known DenySettingsMode values.
     * 
     * @return known DenySettingsMode values.
     */
    public static Collection<DenySettingsMode> values() {
        return values(DenySettingsMode.class);
    }
}
