// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users
 * are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a
 * resource, but they can't modify or delete it.
 */
public final class LockLevel extends ExpandableStringEnum<LockLevel> {
    /**
     * Static value NotSpecified for LockLevel.
     */
    public static final LockLevel NOT_SPECIFIED = fromString("NotSpecified");

    /**
     * Static value CanNotDelete for LockLevel.
     */
    public static final LockLevel CAN_NOT_DELETE = fromString("CanNotDelete");

    /**
     * Static value ReadOnly for LockLevel.
     */
    public static final LockLevel READ_ONLY = fromString("ReadOnly");

    /**
     * Creates a new instance of LockLevel value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LockLevel() {
    }

    /**
     * Creates or finds a LockLevel from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LockLevel.
     */
    @JsonCreator
    public static LockLevel fromString(String name) {
        return fromString(name, LockLevel.class);
    }

    /**
     * Gets known LockLevel values.
     * 
     * @return known LockLevel values.
     */
    public static Collection<LockLevel> values() {
        return values(LockLevel.class);
    }
}
