// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The managed resource model.
 */
@Fluent
public final class ManagedResourceReference extends ResourceReference {
    /*
     * Current management state of the resource in the deployment stack.
     */
    @JsonProperty(value = "status")
    private ResourceStatusMode status;

    /*
     * denyAssignment settings applied to the resource.
     */
    @JsonProperty(value = "denyStatus")
    private DenyStatusMode denyStatus;

    /**
     * Creates an instance of ManagedResourceReference class.
     */
    public ManagedResourceReference() {
    }

    /**
     * Get the status property: Current management state of the resource in the deployment stack.
     * 
     * @return the status value.
     */
    public ResourceStatusMode status() {
        return this.status;
    }

    /**
     * Set the status property: Current management state of the resource in the deployment stack.
     * 
     * @param status the status value to set.
     * @return the ManagedResourceReference object itself.
     */
    public ManagedResourceReference withStatus(ResourceStatusMode status) {
        this.status = status;
        return this;
    }

    /**
     * Get the denyStatus property: denyAssignment settings applied to the resource.
     * 
     * @return the denyStatus value.
     */
    public DenyStatusMode denyStatus() {
        return this.denyStatus;
    }

    /**
     * Set the denyStatus property: denyAssignment settings applied to the resource.
     * 
     * @param denyStatus the denyStatus value to set.
     * @return the ManagedResourceReference object itself.
     */
    public ManagedResourceReference withDenyStatus(DenyStatusMode denyStatus) {
        this.denyStatus = denyStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
