// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The policy property value override.
 */
@Fluent
public final class OverrideModel {
    /*
     * The override kind.
     */
    @JsonProperty(value = "kind")
    private OverrideKind kind;

    /*
     * The value to override the policy property.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * The list of the selector expressions.
     */
    @JsonProperty(value = "selectors")
    private List<Selector> selectors;

    /**
     * Creates an instance of OverrideModel class.
     */
    public OverrideModel() {
    }

    /**
     * Get the kind property: The override kind.
     * 
     * @return the kind value.
     */
    public OverrideKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The override kind.
     * 
     * @param kind the kind value to set.
     * @return the OverrideModel object itself.
     */
    public OverrideModel withKind(OverrideKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the value property: The value to override the policy property.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value to override the policy property.
     * 
     * @param value the value value to set.
     * @return the OverrideModel object itself.
     */
    public OverrideModel withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the selectors property: The list of the selector expressions.
     * 
     * @return the selectors value.
     */
    public List<Selector> selectors() {
        return this.selectors;
    }

    /**
     * Set the selectors property: The list of the selector expressions.
     * 
     * @param selectors the selectors value to set.
     * @return the OverrideModel object itself.
     */
    public OverrideModel withSelectors(List<Selector> selectors) {
        this.selectors = selectors;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (selectors() != null) {
            selectors().forEach(e -> e.validate());
        }
    }
}
