// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The resourceId extended model. This is used to document failed resources with a resourceId and a corresponding error.
 */
@Fluent
public final class ResourceReferenceExtended extends ResourceReference {
    /*
     * The error detail.
     */
    @JsonProperty(value = "error")
    private ManagementError error;

    /**
     * Creates an instance of ResourceReferenceExtended class.
     */
    public ResourceReferenceExtended() {
    }

    /**
     * Get the error property: The error detail.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The error detail.
     * 
     * @param error the error value to set.
     * @return the ResourceReferenceExtended object itself.
     */
    public ResourceReferenceExtended withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
