// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Role definition properties.
 */
@Fluent
public final class RoleDefinition {
    /*
     * The role definition ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The role definition name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * If this is a service role.
     */
    @JsonProperty(value = "isServiceRole")
    private Boolean isServiceRole;

    /*
     * Role definition permissions.
     */
    @JsonProperty(value = "permissions")
    private List<Permission> permissions;

    /*
     * Role definition assignable scopes.
     */
    @JsonProperty(value = "scopes")
    private List<String> scopes;

    /**
     * Creates an instance of RoleDefinition class.
     */
    public RoleDefinition() {
    }

    /**
     * Get the id property: The role definition ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The role definition ID.
     * 
     * @param id the id value to set.
     * @return the RoleDefinition object itself.
     */
    public RoleDefinition withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The role definition name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The role definition name.
     * 
     * @param name the name value to set.
     * @return the RoleDefinition object itself.
     */
    public RoleDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the isServiceRole property: If this is a service role.
     * 
     * @return the isServiceRole value.
     */
    public Boolean isServiceRole() {
        return this.isServiceRole;
    }

    /**
     * Set the isServiceRole property: If this is a service role.
     * 
     * @param isServiceRole the isServiceRole value to set.
     * @return the RoleDefinition object itself.
     */
    public RoleDefinition withIsServiceRole(Boolean isServiceRole) {
        this.isServiceRole = isServiceRole;
        return this;
    }

    /**
     * Get the permissions property: Role definition permissions.
     * 
     * @return the permissions value.
     */
    public List<Permission> permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: Role definition permissions.
     * 
     * @param permissions the permissions value to set.
     * @return the RoleDefinition object itself.
     */
    public RoleDefinition withPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Get the scopes property: Role definition assignable scopes.
     * 
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: Role definition assignable scopes.
     * 
     * @param scopes the scopes value to set.
     * @return the RoleDefinition object itself.
     */
    public RoleDefinition withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (permissions() != null) {
            permissions().forEach(e -> e.validate());
        }
    }
}
