// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluent.models.SubscriptionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Subscription list operation response.
 */
@Fluent
public final class SubscriptionListResult {
    /*
     * An array of subscriptions.
     */
    @JsonProperty(value = "value")
    private List<SubscriptionInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink", required = true)
    private String nextLink;

    /**
     * Creates an instance of SubscriptionListResult class.
     */
    public SubscriptionListResult() {
    }

    /**
     * Get the value property: An array of subscriptions.
     * 
     * @return the value value.
     */
    public List<SubscriptionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of subscriptions.
     * 
     * @param value the value value to set.
     * @return the SubscriptionListResult object itself.
     */
    public SubscriptionListResult withValue(List<SubscriptionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SubscriptionListResult object itself.
     */
    public SubscriptionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
        if (nextLink() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property nextLink in model SubscriptionListResult"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SubscriptionListResult.class);
}
