// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies whether template expressions are evaluated within the scope of the parent template or nested template.
 */
@Fluent
public final class ExpressionEvaluationOptions implements JsonSerializable<ExpressionEvaluationOptions> {
    /*
     * The scope to be used for evaluation of parameters, variables and functions in a nested template.
     */
    private ExpressionEvaluationOptionsScopeType scope;

    /**
     * Creates an instance of ExpressionEvaluationOptions class.
     */
    public ExpressionEvaluationOptions() {
    }

    /**
     * Get the scope property: The scope to be used for evaluation of parameters, variables and functions in a nested
     * template.
     * 
     * @return the scope value.
     */
    public ExpressionEvaluationOptionsScopeType scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The scope to be used for evaluation of parameters, variables and functions in a nested
     * template.
     * 
     * @param scope the scope value to set.
     * @return the ExpressionEvaluationOptions object itself.
     */
    public ExpressionEvaluationOptions withScope(ExpressionEvaluationOptionsScopeType scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressionEvaluationOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressionEvaluationOptions if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressionEvaluationOptions.
     */
    public static ExpressionEvaluationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressionEvaluationOptions deserializedExpressionEvaluationOptions = new ExpressionEvaluationOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedExpressionEvaluationOptions.scope
                        = ExpressionEvaluationOptionsScopeType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressionEvaluationOptions;
        });
    }
}
