/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.ProviderInner;
import com.azure.resourcemanager.resources.models.DebugSetting;
import com.azure.resourcemanager.resources.models.Dependency;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.OnErrorDeploymentExtended;
import com.azure.resourcemanager.resources.models.ParametersLink;
import com.azure.resourcemanager.resources.models.ProvisioningState;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.TemplateLink;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DeploymentPropertiesExtended
implements JsonSerializable<DeploymentPropertiesExtended> {
    private ProvisioningState provisioningState;
    private String correlationId;
    private OffsetDateTime timestamp;
    private String duration;
    private Object outputs;
    private List<ProviderInner> providers;
    private List<Dependency> dependencies;
    private TemplateLink templateLink;
    private Object parameters;
    private ParametersLink parametersLink;
    private DeploymentMode mode;
    private DebugSetting debugSetting;
    private OnErrorDeploymentExtended onErrorDeployment;
    private String templateHash;
    private List<ResourceReference> outputResources;
    private List<ResourceReference> validatedResources;
    private ManagementError error;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public String duration() {
        return this.duration;
    }

    public Object outputs() {
        return this.outputs;
    }

    public List<ProviderInner> providers() {
        return this.providers;
    }

    public List<Dependency> dependencies() {
        return this.dependencies;
    }

    public TemplateLink templateLink() {
        return this.templateLink;
    }

    public Object parameters() {
        return this.parameters;
    }

    public ParametersLink parametersLink() {
        return this.parametersLink;
    }

    public DeploymentMode mode() {
        return this.mode;
    }

    public DebugSetting debugSetting() {
        return this.debugSetting;
    }

    public OnErrorDeploymentExtended onErrorDeployment() {
        return this.onErrorDeployment;
    }

    public String templateHash() {
        return this.templateHash;
    }

    public List<ResourceReference> outputResources() {
        return this.outputResources;
    }

    public List<ResourceReference> validatedResources() {
        return this.validatedResources;
    }

    public ManagementError error() {
        return this.error;
    }

    public void validate() {
        if (this.providers() != null) {
            this.providers().forEach(e -> e.validate());
        }
        if (this.dependencies() != null) {
            this.dependencies().forEach(e -> e.validate());
        }
        if (this.templateLink() != null) {
            this.templateLink().validate();
        }
        if (this.parametersLink() != null) {
            this.parametersLink().validate();
        }
        if (this.debugSetting() != null) {
            this.debugSetting().validate();
        }
        if (this.onErrorDeployment() != null) {
            this.onErrorDeployment().validate();
        }
        if (this.outputResources() != null) {
            this.outputResources().forEach(e -> e.validate());
        }
        if (this.validatedResources() != null) {
            this.validatedResources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DeploymentPropertiesExtended fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentPropertiesExtended)jsonReader.readObject(reader -> {
            DeploymentPropertiesExtended deserializedDeploymentPropertiesExtended = new DeploymentPropertiesExtended();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.correlationId = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.duration = reader.getString();
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.outputs = reader.readUntyped();
                    continue;
                }
                if ("providers".equals(fieldName)) {
                    List providers;
                    deserializedDeploymentPropertiesExtended.providers = providers = reader.readArray(reader1 -> ProviderInner.fromJson(reader1));
                    continue;
                }
                if ("dependencies".equals(fieldName)) {
                    List dependencies;
                    deserializedDeploymentPropertiesExtended.dependencies = dependencies = reader.readArray(reader1 -> Dependency.fromJson(reader1));
                    continue;
                }
                if ("templateLink".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.templateLink = TemplateLink.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.parameters = reader.readUntyped();
                    continue;
                }
                if ("parametersLink".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.parametersLink = ParametersLink.fromJson(reader);
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.mode = DeploymentMode.fromString(reader.getString());
                    continue;
                }
                if ("debugSetting".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.debugSetting = DebugSetting.fromJson(reader);
                    continue;
                }
                if ("onErrorDeployment".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.onErrorDeployment = OnErrorDeploymentExtended.fromJson(reader);
                    continue;
                }
                if ("templateHash".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.templateHash = reader.getString();
                    continue;
                }
                if ("outputResources".equals(fieldName)) {
                    List outputResources;
                    deserializedDeploymentPropertiesExtended.outputResources = outputResources = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    continue;
                }
                if ("validatedResources".equals(fieldName)) {
                    List validatedResources;
                    deserializedDeploymentPropertiesExtended.validatedResources = validatedResources = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentPropertiesExtended;
        });
    }
}

