// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.TagCount;
import java.io.IOException;
import java.util.List;

/**
 * Tag details.
 */
@Fluent
public final class TagDetailsInner implements JsonSerializable<TagDetailsInner> {
    /*
     * The tag name ID.
     */
    private String id;

    /*
     * The tag name.
     */
    private String tagName;

    /*
     * The total number of resources that use the resource tag. When a tag is initially created and has no associated
     * resources, the value is 0.
     */
    private TagCount count;

    /*
     * The list of tag values.
     */
    private List<TagValueInner> values;

    /**
     * Creates an instance of TagDetailsInner class.
     */
    public TagDetailsInner() {
    }

    /**
     * Get the id property: The tag name ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the tagName property: The tag name.
     * 
     * @return the tagName value.
     */
    public String tagName() {
        return this.tagName;
    }

    /**
     * Set the tagName property: The tag name.
     * 
     * @param tagName the tagName value to set.
     * @return the TagDetailsInner object itself.
     */
    public TagDetailsInner withTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    /**
     * Get the count property: The total number of resources that use the resource tag. When a tag is initially created
     * and has no associated resources, the value is 0.
     * 
     * @return the count value.
     */
    public TagCount count() {
        return this.count;
    }

    /**
     * Set the count property: The total number of resources that use the resource tag. When a tag is initially created
     * and has no associated resources, the value is 0.
     * 
     * @param count the count value to set.
     * @return the TagDetailsInner object itself.
     */
    public TagDetailsInner withCount(TagCount count) {
        this.count = count;
        return this;
    }

    /**
     * Get the values property: The list of tag values.
     * 
     * @return the values value.
     */
    public List<TagValueInner> values() {
        return this.values;
    }

    /**
     * Set the values property: The list of tag values.
     * 
     * @param values the values value to set.
     * @return the TagDetailsInner object itself.
     */
    public TagDetailsInner withValues(List<TagValueInner> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (count() != null) {
            count().validate();
        }
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tagName", this.tagName);
        jsonWriter.writeJsonField("count", this.count);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagDetailsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagDetailsInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TagDetailsInner.
     */
    public static TagDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagDetailsInner deserializedTagDetailsInner = new TagDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTagDetailsInner.id = reader.getString();
                } else if ("tagName".equals(fieldName)) {
                    deserializedTagDetailsInner.tagName = reader.getString();
                } else if ("count".equals(fieldName)) {
                    deserializedTagDetailsInner.count = TagCount.fromJson(reader);
                } else if ("values".equals(fieldName)) {
                    List<TagValueInner> values = reader.readArray(reader1 -> TagValueInner.fromJson(reader1));
                    deserializedTagDetailsInner.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagDetailsInner;
        });
    }
}
