// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.LocationInner;
import java.io.IOException;
import java.util.List;

/**
 * Location list operation response.
 */
@Fluent
public final class LocationListResult implements JsonSerializable<LocationListResult> {
    /*
     * An array of locations.
     */
    private List<LocationInner> value;

    /**
     * Creates an instance of LocationListResult class.
     */
    public LocationListResult() {
    }

    /**
     * Get the value property: An array of locations.
     * 
     * @return the value value.
     */
    public List<LocationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of locations.
     * 
     * @param value the value value to set.
     * @return the LocationListResult object itself.
     */
    public LocationListResult withValue(List<LocationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocationListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocationListResult.
     */
    public static LocationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocationListResult deserializedLocationListResult = new LocationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<LocationInner> value = reader.readArray(reader1 -> LocationInner.fromJson(reader1));
                    deserializedLocationListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocationListResult;
        });
    }
}
