// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The resource type aliases definition.
 */
@Fluent
public final class ResourceTypeAliases implements JsonSerializable<ResourceTypeAliases> {
    /*
     * The resource type name.
     */
    private String resourceType;

    /*
     * The aliases for property names.
     */
    private List<Alias> aliases;

    /**
     * Creates an instance of ResourceTypeAliases class.
     */
    public ResourceTypeAliases() {
    }

    /**
     * Get the resourceType property: The resource type name.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Set the resourceType property: The resource type name.
     * 
     * @param resourceType the resourceType value to set.
     * @return the ResourceTypeAliases object itself.
     */
    public ResourceTypeAliases withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    /**
     * Get the aliases property: The aliases for property names.
     * 
     * @return the aliases value.
     */
    public List<Alias> aliases() {
        return this.aliases;
    }

    /**
     * Set the aliases property: The aliases for property names.
     * 
     * @param aliases the aliases value to set.
     * @return the ResourceTypeAliases object itself.
     */
    public ResourceTypeAliases withAliases(List<Alias> aliases) {
        this.aliases = aliases;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (aliases() != null) {
            aliases().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeArrayField("aliases", this.aliases, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceTypeAliases from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceTypeAliases if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceTypeAliases.
     */
    public static ResourceTypeAliases fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceTypeAliases deserializedResourceTypeAliases = new ResourceTypeAliases();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceType".equals(fieldName)) {
                    deserializedResourceTypeAliases.resourceType = reader.getString();
                } else if ("aliases".equals(fieldName)) {
                    List<Alias> aliases = reader.readArray(reader1 -> Alias.fromJson(reader1));
                    deserializedResourceTypeAliases.aliases = aliases;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceTypeAliases;
        });
    }
}
