// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Data boundary properties.
 */
@Fluent
public final class DataBoundaryProperties implements JsonSerializable<DataBoundaryProperties> {
    /*
     * The data boundary definition.
     */
    private DataBoundary dataBoundary;

    /*
     * Denotes the state of provisioning.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of DataBoundaryProperties class.
     */
    public DataBoundaryProperties() {
    }

    /**
     * Get the dataBoundary property: The data boundary definition.
     * 
     * @return the dataBoundary value.
     */
    public DataBoundary dataBoundary() {
        return this.dataBoundary;
    }

    /**
     * Set the dataBoundary property: The data boundary definition.
     * 
     * @param dataBoundary the dataBoundary value to set.
     * @return the DataBoundaryProperties object itself.
     */
    public DataBoundaryProperties withDataBoundary(DataBoundary dataBoundary) {
        this.dataBoundary = dataBoundary;
        return this;
    }

    /**
     * Get the provisioningState property: Denotes the state of provisioning.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataBoundary", this.dataBoundary == null ? null : this.dataBoundary.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataBoundaryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataBoundaryProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataBoundaryProperties.
     */
    public static DataBoundaryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataBoundaryProperties deserializedDataBoundaryProperties = new DataBoundaryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataBoundary".equals(fieldName)) {
                    deserializedDataBoundaryProperties.dataBoundary = DataBoundary.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedDataBoundaryProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataBoundaryProperties;
        });
    }
}
