// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deployment What-If operation settings.
 */
@Fluent
public final class DeploymentWhatIfSettings implements JsonSerializable<DeploymentWhatIfSettings> {
    /*
     * The format of the What-If results
     */
    private WhatIfResultFormat resultFormat;

    /**
     * Creates an instance of DeploymentWhatIfSettings class.
     */
    public DeploymentWhatIfSettings() {
    }

    /**
     * Get the resultFormat property: The format of the What-If results.
     * 
     * @return the resultFormat value.
     */
    public WhatIfResultFormat resultFormat() {
        return this.resultFormat;
    }

    /**
     * Set the resultFormat property: The format of the What-If results.
     * 
     * @param resultFormat the resultFormat value to set.
     * @return the DeploymentWhatIfSettings object itself.
     */
    public DeploymentWhatIfSettings withResultFormat(WhatIfResultFormat resultFormat) {
        this.resultFormat = resultFormat;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultFormat", this.resultFormat == null ? null : this.resultFormat.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentWhatIfSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentWhatIfSettings if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentWhatIfSettings.
     */
    public static DeploymentWhatIfSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentWhatIfSettings deserializedDeploymentWhatIfSettings = new DeploymentWhatIfSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resultFormat".equals(fieldName)) {
                    deserializedDeploymentWhatIfSettings.resultFormat
                        = WhatIfResultFormat.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentWhatIfSettings;
        });
    }
}
