// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A dictionary of name and value pairs.
 */
@Fluent
public final class Tags implements JsonSerializable<Tags> {
    /*
     * Dictionary of <string>
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of Tags class.
     */
    public Tags() {
    }

    /**
     * Get the tags property: Dictionary of &lt;string&gt;.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Dictionary of &lt;string&gt;.
     * 
     * @param tags the tags value to set.
     * @return the Tags object itself.
     */
    public Tags withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Tags from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Tags if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Tags.
     */
    public static Tags fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Tags deserializedTags = new Tags();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedTags.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTags;
        });
    }
}
