// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ExtendedLocation;
import com.azure.resourcemanager.resources.models.Identity;
import com.azure.resourcemanager.resources.models.Plan;
import com.azure.resourcemanager.resources.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Resource information.
 */
@Fluent
public final class GenericResourceExpandedInner extends GenericResourceInner {
    /*
     * The created time of the resource. This is only present if requested via the $expand query parameter.
     */
    private OffsetDateTime createdTime;

    /*
     * The changed time of the resource. This is only present if requested via the $expand query parameter.
     */
    private OffsetDateTime changedTime;

    /*
     * The provisioning state of the resource. This is only present if requested via the $expand query parameter.
     */
    private String provisioningState;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of GenericResourceExpandedInner class.
     */
    public GenericResourceExpandedInner() {
    }

    /**
     * Get the createdTime property: The created time of the resource. This is only present if requested via the $expand
     * query parameter.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Get the changedTime property: The changed time of the resource. This is only present if requested via the $expand
     * query parameter.
     * 
     * @return the changedTime value.
     */
    public OffsetDateTime changedTime() {
        return this.changedTime;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource. This is only present if requested via
     * the $expand query parameter.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withPlan(Plan plan) {
        super.withPlan(plan);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withProperties(Object properties) {
        super.withProperties(properties);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withManagedBy(String managedBy) {
        super.withManagedBy(managedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withSku(Sku sku) {
        super.withSku(sku);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withIdentity(Identity identity) {
        super.withIdentity(identity);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withExtendedLocation(ExtendedLocation extendedLocation) {
        super.withExtendedLocation(extendedLocation);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceExpandedInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("plan", plan());
        jsonWriter.writeUntypedField("properties", properties());
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeStringField("managedBy", managedBy());
        jsonWriter.writeJsonField("sku", sku());
        jsonWriter.writeJsonField("identity", identity());
        jsonWriter.writeJsonField("extendedLocation", extendedLocation());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GenericResourceExpandedInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GenericResourceExpandedInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GenericResourceExpandedInner.
     */
    public static GenericResourceExpandedInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GenericResourceExpandedInner deserializedGenericResourceExpandedInner = new GenericResourceExpandedInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGenericResourceExpandedInner.withTags(tags);
                } else if ("plan".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.withPlan(Plan.fromJson(reader));
                } else if ("properties".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.withProperties(reader.readUntyped());
                } else if ("kind".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.withKind(reader.getString());
                } else if ("managedBy".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.withManagedBy(reader.getString());
                } else if ("sku".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.withSku(Sku.fromJson(reader));
                } else if ("identity".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.withIdentity(Identity.fromJson(reader));
                } else if ("extendedLocation".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.withExtendedLocation(ExtendedLocation.fromJson(reader));
                } else if ("createdTime".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.createdTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("changedTime".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.changedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGenericResourceExpandedInner.provisioningState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGenericResourceExpandedInner;
        });
    }
}
