// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The definition of a parameter that can be provided to the policy.
 */
@Fluent
public final class ParameterDefinitionsValue implements JsonSerializable<ParameterDefinitionsValue> {
    /*
     * The data type of the parameter.
     */
    private ParameterType type;

    /*
     * The allowed values for the parameter.
     */
    private List<Object> allowedValues;

    /*
     * The default value for the parameter if no value is provided.
     */
    private Object defaultValue;

    /*
     * General metadata for the parameter.
     */
    private ParameterDefinitionsValueMetadata metadata;

    /**
     * Creates an instance of ParameterDefinitionsValue class.
     */
    public ParameterDefinitionsValue() {
    }

    /**
     * Get the type property: The data type of the parameter.
     * 
     * @return the type value.
     */
    public ParameterType type() {
        return this.type;
    }

    /**
     * Set the type property: The data type of the parameter.
     * 
     * @param type the type value to set.
     * @return the ParameterDefinitionsValue object itself.
     */
    public ParameterDefinitionsValue withType(ParameterType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the allowedValues property: The allowed values for the parameter.
     * 
     * @return the allowedValues value.
     */
    public List<Object> allowedValues() {
        return this.allowedValues;
    }

    /**
     * Set the allowedValues property: The allowed values for the parameter.
     * 
     * @param allowedValues the allowedValues value to set.
     * @return the ParameterDefinitionsValue object itself.
     */
    public ParameterDefinitionsValue withAllowedValues(List<Object> allowedValues) {
        this.allowedValues = allowedValues;
        return this;
    }

    /**
     * Get the defaultValue property: The default value for the parameter if no value is provided.
     * 
     * @return the defaultValue value.
     */
    public Object defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: The default value for the parameter if no value is provided.
     * 
     * @param defaultValue the defaultValue value to set.
     * @return the ParameterDefinitionsValue object itself.
     */
    public ParameterDefinitionsValue withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Get the metadata property: General metadata for the parameter.
     * 
     * @return the metadata value.
     */
    public ParameterDefinitionsValueMetadata metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: General metadata for the parameter.
     * 
     * @param metadata the metadata value to set.
     * @return the ParameterDefinitionsValue object itself.
     */
    public ParameterDefinitionsValue withMetadata(ParameterDefinitionsValueMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metadata() != null) {
            metadata().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("allowedValues", this.allowedValues,
            (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeUntypedField("defaultValue", this.defaultValue);
        jsonWriter.writeJsonField("metadata", this.metadata);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ParameterDefinitionsValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ParameterDefinitionsValue if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ParameterDefinitionsValue.
     */
    public static ParameterDefinitionsValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ParameterDefinitionsValue deserializedParameterDefinitionsValue = new ParameterDefinitionsValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedParameterDefinitionsValue.type = ParameterType.fromString(reader.getString());
                } else if ("allowedValues".equals(fieldName)) {
                    List<Object> allowedValues = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedParameterDefinitionsValue.allowedValues = allowedValues;
                } else if ("defaultValue".equals(fieldName)) {
                    deserializedParameterDefinitionsValue.defaultValue = reader.readUntyped();
                } else if ("metadata".equals(fieldName)) {
                    deserializedParameterDefinitionsValue.metadata = ParameterDefinitionsValueMetadata.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedParameterDefinitionsValue;
        });
    }
}
