// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Operation status message object.
 */
@Fluent
public final class StatusMessage implements JsonSerializable<StatusMessage> {
    /*
     * Status of the deployment operation.
     */
    private String status;

    /*
     * The error reported by the operation.
     */
    private ManagementError error;

    /**
     * Creates an instance of StatusMessage class.
     */
    public StatusMessage() {
    }

    /**
     * Get the status property: Status of the deployment operation.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: Status of the deployment operation.
     * 
     * @param status the status value to set.
     * @return the StatusMessage object itself.
     */
    public StatusMessage withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the error property: The error reported by the operation.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The error reported by the operation.
     * 
     * @param error the error value to set.
     * @return the StatusMessage object itself.
     */
    public StatusMessage withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StatusMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StatusMessage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the StatusMessage.
     */
    public static StatusMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StatusMessage deserializedStatusMessage = new StatusMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedStatusMessage.status = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedStatusMessage.error = ManagementError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStatusMessage;
        });
    }
}
