// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DataBoundaryProperties;
import java.io.IOException;

/**
 * A data boundary definition.
 */
@Fluent
public final class DataBoundaryDefinitionInner extends ProxyResource {
    /*
     * Data boundary properties
     */
    private DataBoundaryProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DataBoundaryDefinitionInner class.
     */
    public DataBoundaryDefinitionInner() {
    }

    /**
     * Get the properties property: Data boundary properties.
     * 
     * @return the properties value.
     */
    public DataBoundaryProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Data boundary properties.
     * 
     * @param properties the properties value to set.
     * @return the DataBoundaryDefinitionInner object itself.
     */
    public DataBoundaryDefinitionInner withProperties(DataBoundaryProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataBoundaryDefinitionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataBoundaryDefinitionInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataBoundaryDefinitionInner.
     */
    public static DataBoundaryDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataBoundaryDefinitionInner deserializedDataBoundaryDefinitionInner = new DataBoundaryDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDataBoundaryDefinitionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDataBoundaryDefinitionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDataBoundaryDefinitionInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDataBoundaryDefinitionInner.properties = DataBoundaryProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedDataBoundaryDefinitionInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataBoundaryDefinitionInner;
        });
    }
}
