// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ExtendedLocation;
import com.azure.resourcemanager.resources.models.Identity;
import com.azure.resourcemanager.resources.models.Plan;
import com.azure.resourcemanager.resources.models.Sku;
import java.io.IOException;
import java.util.Map;

/**
 * Resource information.
 */
@Fluent
public class GenericResourceInner extends Resource {
    /*
     * The plan of the resource.
     */
    private Plan plan;

    /*
     * The resource properties.
     */
    private Object properties;

    /*
     * The kind of the resource.
     */
    private String kind;

    /*
     * ID of the resource that manages this resource.
     */
    private String managedBy;

    /*
     * The SKU of the resource.
     */
    private Sku sku;

    /*
     * The identity of the resource.
     */
    private Identity identity;

    /*
     * Resource extended location.
     */
    private ExtendedLocation extendedLocation;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of GenericResourceInner class.
     */
    public GenericResourceInner() {
    }

    /**
     * Get the plan property: The plan of the resource.
     * 
     * @return the plan value.
     */
    public Plan plan() {
        return this.plan;
    }

    /**
     * Set the plan property: The plan of the resource.
     * 
     * @param plan the plan value to set.
     * @return the GenericResourceInner object itself.
     */
    public GenericResourceInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    /**
     * Get the properties property: The resource properties.
     * 
     * @return the properties value.
     */
    public Object properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The resource properties.
     * 
     * @param properties the properties value to set.
     * @return the GenericResourceInner object itself.
     */
    public GenericResourceInner withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the kind property: The kind of the resource.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The kind of the resource.
     * 
     * @param kind the kind value to set.
     * @return the GenericResourceInner object itself.
     */
    public GenericResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the managedBy property: ID of the resource that manages this resource.
     * 
     * @return the managedBy value.
     */
    public String managedBy() {
        return this.managedBy;
    }

    /**
     * Set the managedBy property: ID of the resource that manages this resource.
     * 
     * @param managedBy the managedBy value to set.
     * @return the GenericResourceInner object itself.
     */
    public GenericResourceInner withManagedBy(String managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    /**
     * Get the sku property: The SKU of the resource.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU of the resource.
     * 
     * @param sku the sku value to set.
     * @return the GenericResourceInner object itself.
     */
    public GenericResourceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the identity property: The identity of the resource.
     * 
     * @return the identity value.
     */
    public Identity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the resource.
     * 
     * @param identity the identity value to set.
     * @return the GenericResourceInner object itself.
     */
    public GenericResourceInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the extendedLocation property: Resource extended location.
     * 
     * @return the extendedLocation value.
     */
    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    /**
     * Set the extendedLocation property: Resource extended location.
     * 
     * @param extendedLocation the extendedLocation value to set.
     * @return the GenericResourceInner object itself.
     */
    public GenericResourceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GenericResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (plan() != null) {
            plan().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (extendedLocation() != null) {
            extendedLocation().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("plan", this.plan);
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeStringField("managedBy", this.managedBy);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GenericResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GenericResourceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GenericResourceInner.
     */
    public static GenericResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GenericResourceInner deserializedGenericResourceInner = new GenericResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGenericResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGenericResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGenericResourceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedGenericResourceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGenericResourceInner.withTags(tags);
                } else if ("plan".equals(fieldName)) {
                    deserializedGenericResourceInner.plan = Plan.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedGenericResourceInner.properties = reader.readUntyped();
                } else if ("kind".equals(fieldName)) {
                    deserializedGenericResourceInner.kind = reader.getString();
                } else if ("managedBy".equals(fieldName)) {
                    deserializedGenericResourceInner.managedBy = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedGenericResourceInner.sku = Sku.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedGenericResourceInner.identity = Identity.fromJson(reader);
                } else if ("extendedLocation".equals(fieldName)) {
                    deserializedGenericResourceInner.extendedLocation = ExtendedLocation.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGenericResourceInner;
        });
    }
}
