// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.resources.fluent.DataBoundariesClient;
import com.azure.resourcemanager.resources.fluent.models.DataBoundaryDefinitionInner;
import com.azure.resourcemanager.resources.models.DefaultName;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DataBoundariesClient.
 */
public final class DataBoundariesClientImpl implements DataBoundariesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DataBoundariesService service;

    /**
     * The service client containing this operation class.
     */
    private final DataBoundariesManagementClientImpl client;

    /**
     * Initializes an instance of DataBoundariesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    DataBoundariesClientImpl(DataBoundariesManagementClientImpl client) {
        this.service
            = RestProxy.create(DataBoundariesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for DataBoundariesManagementClientDataBoundaries to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "DataBoundariesManage")
    public interface DataBoundariesService {
        @Headers({ "Content-Type: application/json" })
        @Put("/providers/Microsoft.Resources/dataBoundaries/{default}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataBoundaryDefinitionInner>> put(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("default") DefaultName defaultParameter,
            @BodyParam("application/json") DataBoundaryDefinitionInner dataBoundaryDefinition,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Resources/dataBoundaries/{default}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataBoundaryDefinitionInner>> getTenant(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("default") DefaultName defaultParameter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.Resources/dataBoundaries/{default}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataBoundaryDefinitionInner>> getScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope, @QueryParam("api-version") String apiVersion,
            @PathParam("default") DefaultName defaultParameter, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataBoundaryDefinitionInner>> putWithResponseAsync(DefaultName defaultParameter,
        DataBoundaryDefinitionInner dataBoundaryDefinition) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (dataBoundaryDefinition == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter dataBoundaryDefinition is required and cannot be null."));
        } else {
            dataBoundaryDefinition.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.put(this.client.getEndpoint(), this.client.getApiVersion(),
                defaultParameter, dataBoundaryDefinition, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DataBoundaryDefinitionInner>> putWithResponseAsync(DefaultName defaultParameter,
        DataBoundaryDefinitionInner dataBoundaryDefinition, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        if (dataBoundaryDefinition == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter dataBoundaryDefinition is required and cannot be null."));
        } else {
            dataBoundaryDefinition.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.put(this.client.getEndpoint(), this.client.getApiVersion(), defaultParameter,
            dataBoundaryDefinition, accept, context);
    }

    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataBoundaryDefinitionInner> putAsync(DefaultName defaultParameter,
        DataBoundaryDefinitionInner dataBoundaryDefinition) {
        return putWithResponseAsync(defaultParameter, dataBoundaryDefinition)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataBoundaryDefinitionInner> putWithResponse(DefaultName defaultParameter,
        DataBoundaryDefinitionInner dataBoundaryDefinition, Context context) {
        return putWithResponseAsync(defaultParameter, dataBoundaryDefinition, context).block();
    }

    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataBoundaryDefinitionInner put(DefaultName defaultParameter,
        DataBoundaryDefinitionInner dataBoundaryDefinition) {
        return putWithResponse(defaultParameter, dataBoundaryDefinition, Context.NONE).getValue();
    }

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataBoundaryDefinitionInner>> getTenantWithResponseAsync(DefaultName defaultParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getTenant(this.client.getEndpoint(), this.client.getApiVersion(),
                defaultParameter, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DataBoundaryDefinitionInner>> getTenantWithResponseAsync(DefaultName defaultParameter,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getTenant(this.client.getEndpoint(), this.client.getApiVersion(), defaultParameter, accept,
            context);
    }

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataBoundaryDefinitionInner> getTenantAsync(DefaultName defaultParameter) {
        return getTenantWithResponseAsync(defaultParameter).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataBoundaryDefinitionInner> getTenantWithResponse(DefaultName defaultParameter, Context context) {
        return getTenantWithResponseAsync(defaultParameter, context).block();
    }

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataBoundaryDefinitionInner getTenant(DefaultName defaultParameter) {
        return getTenantWithResponse(defaultParameter, Context.NONE).getValue();
    }

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataBoundaryDefinitionInner>> getScopeWithResponseAsync(String scope,
        DefaultName defaultParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getScope(this.client.getEndpoint(), scope, this.client.getApiVersion(),
                defaultParameter, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DataBoundaryDefinitionInner>> getScopeWithResponseAsync(String scope,
        DefaultName defaultParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), defaultParameter, accept,
            context);
    }

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataBoundaryDefinitionInner> getScopeAsync(String scope, DefaultName defaultParameter) {
        return getScopeWithResponseAsync(scope, defaultParameter).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataBoundaryDefinitionInner> getScopeWithResponse(String scope, DefaultName defaultParameter,
        Context context) {
        return getScopeWithResponseAsync(scope, defaultParameter, context).block();
    }

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataBoundaryDefinitionInner getScope(String scope, DefaultName defaultParameter) {
        return getScopeWithResponse(scope, defaultParameter, Context.NONE).getValue();
    }
}
