// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ApiProfile model.
 */
@Immutable
public final class ApiProfile implements JsonSerializable<ApiProfile> {
    /*
     * The profile version.
     */
    private String profileVersion;

    /*
     * The API version.
     */
    private String apiVersion;

    /**
     * Creates an instance of ApiProfile class.
     */
    public ApiProfile() {
    }

    /**
     * Get the profileVersion property: The profile version.
     * 
     * @return the profileVersion value.
     */
    public String profileVersion() {
        return this.profileVersion;
    }

    /**
     * Get the apiVersion property: The API version.
     * 
     * @return the apiVersion value.
     */
    public String apiVersion() {
        return this.apiVersion;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiProfile if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the ApiProfile.
     */
    public static ApiProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiProfile deserializedApiProfile = new ApiProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("profileVersion".equals(fieldName)) {
                    deserializedApiProfile.profileVersion = reader.getString();
                } else if ("apiVersion".equals(fieldName)) {
                    deserializedApiProfile.apiVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiProfile;
        });
    }
}
