// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The debug setting.
 */
@Fluent
public final class DebugSetting implements JsonSerializable<DebugSetting> {
    /*
     * Specifies the type of information to log for debugging. The permitted values are none, requestContent,
     * responseContent, or both requestContent and responseContent separated by a comma. The default is none. When
     * setting this value, carefully consider the type of information you are passing in during deployment. By logging
     * information about the request or response, you could potentially expose sensitive data that is retrieved through
     * the deployment operations.
     */
    private String detailLevel;

    /**
     * Creates an instance of DebugSetting class.
     */
    public DebugSetting() {
    }

    /**
     * Get the detailLevel property: Specifies the type of information to log for debugging. The permitted values are
     * none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The
     * default is none. When setting this value, carefully consider the type of information you are passing in during
     * deployment. By logging information about the request or response, you could potentially expose sensitive data
     * that is retrieved through the deployment operations.
     * 
     * @return the detailLevel value.
     */
    public String detailLevel() {
        return this.detailLevel;
    }

    /**
     * Set the detailLevel property: Specifies the type of information to log for debugging. The permitted values are
     * none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The
     * default is none. When setting this value, carefully consider the type of information you are passing in during
     * deployment. By logging information about the request or response, you could potentially expose sensitive data
     * that is retrieved through the deployment operations.
     * 
     * @param detailLevel the detailLevel value to set.
     * @return the DebugSetting object itself.
     */
    public DebugSetting withDetailLevel(String detailLevel) {
        this.detailLevel = detailLevel;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("detailLevel", this.detailLevel);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DebugSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DebugSetting if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DebugSetting.
     */
    public static DebugSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DebugSetting deserializedDebugSetting = new DebugSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("detailLevel".equals(fieldName)) {
                    deserializedDebugSetting.detailLevel = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDebugSetting;
        });
    }
}
