// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.DeploymentStackInner;
import java.io.IOException;
import java.util.List;

/**
 * List of Deployment stacks.
 */
@Fluent
public final class DeploymentStackListResult implements JsonSerializable<DeploymentStackListResult> {
    /*
     * An array of Deployment stacks.
     */
    private List<DeploymentStackInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of DeploymentStackListResult class.
     */
    public DeploymentStackListResult() {
    }

    /**
     * Get the value property: An array of Deployment stacks.
     * 
     * @return the value value.
     */
    public List<DeploymentStackInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of Deployment stacks.
     * 
     * @param value the value value to set.
     * @return the DeploymentStackListResult object itself.
     */
    public DeploymentStackListResult withValue(List<DeploymentStackInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentStackListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentStackListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentStackListResult.
     */
    public static DeploymentStackListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentStackListResult deserializedDeploymentStackListResult = new DeploymentStackListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DeploymentStackInner> value
                        = reader.readArray(reader1 -> DeploymentStackInner.fromJson(reader1));
                    deserializedDeploymentStackListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDeploymentStackListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentStackListResult;
        });
    }
}
