// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
 */
public final class EnforcementMode extends ExpandableStringEnum<EnforcementMode> {
    /**
     * Static value Default for EnforcementMode.
     */
    public static final EnforcementMode DEFAULT = fromString("Default");

    /**
     * Static value DoNotEnforce for EnforcementMode.
     */
    public static final EnforcementMode DO_NOT_ENFORCE = fromString("DoNotEnforce");

    /**
     * Creates a new instance of EnforcementMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public EnforcementMode() {
    }

    /**
     * Creates or finds a EnforcementMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding EnforcementMode.
     */
    public static EnforcementMode fromString(String name) {
        return fromString(name, EnforcementMode.class);
    }

    /**
     * Gets known EnforcementMode values.
     * 
     * @return known EnforcementMode values.
     */
    public static Collection<EnforcementMode> values() {
        return values(EnforcementMode.class);
    }
}
