// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The selector expression.
 */
@Fluent
public final class Selector implements JsonSerializable<Selector> {
    /*
     * The selector kind.
     */
    private SelectorKind kind;

    /*
     * The list of values to filter in.
     */
    private List<String> in;

    /*
     * The list of values to filter out.
     */
    private List<String> notIn;

    /**
     * Creates an instance of Selector class.
     */
    public Selector() {
    }

    /**
     * Get the kind property: The selector kind.
     * 
     * @return the kind value.
     */
    public SelectorKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The selector kind.
     * 
     * @param kind the kind value to set.
     * @return the Selector object itself.
     */
    public Selector withKind(SelectorKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the in property: The list of values to filter in.
     * 
     * @return the in value.
     */
    public List<String> in() {
        return this.in;
    }

    /**
     * Set the in property: The list of values to filter in.
     * 
     * @param in the in value to set.
     * @return the Selector object itself.
     */
    public Selector withIn(List<String> in) {
        this.in = in;
        return this;
    }

    /**
     * Get the notIn property: The list of values to filter out.
     * 
     * @return the notIn value.
     */
    public List<String> notIn() {
        return this.notIn;
    }

    /**
     * Set the notIn property: The list of values to filter out.
     * 
     * @param notIn the notIn value to set.
     * @return the Selector object itself.
     */
    public Selector withNotIn(List<String> notIn) {
        this.notIn = notIn;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeArrayField("in", this.in, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("notIn", this.notIn, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Selector from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Selector if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Selector.
     */
    public static Selector fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Selector deserializedSelector = new Selector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedSelector.kind = SelectorKind.fromString(reader.getString());
                } else if ("in".equals(fieldName)) {
                    List<String> in = reader.readArray(reader1 -> reader1.getString());
                    deserializedSelector.in = in;
                } else if ("notIn".equals(fieldName)) {
                    List<String> notIn = reader.readArray(reader1 -> reader1.getString());
                    deserializedSelector.notIn = notIn;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSelector;
        });
    }
}
