// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The DeploymentDiagnosticsDefinition model.
 */
@Immutable
public final class DeploymentDiagnosticsDefinition implements JsonSerializable<DeploymentDiagnosticsDefinition> {
    /*
     * Denotes the additional response level.
     */
    private Level level;

    /*
     * The error code.
     */
    private String code;

    /*
     * The error message.
     */
    private String message;

    /*
     * The error target.
     */
    private String target;

    /*
     * The error additional info.
     */
    private List<ErrorAdditionalInfo> additionalInfo;

    /**
     * Creates an instance of DeploymentDiagnosticsDefinition class.
     */
    public DeploymentDiagnosticsDefinition() {
    }

    /**
     * Get the level property: Denotes the additional response level.
     * 
     * @return the level value.
     */
    public Level level() {
        return this.level;
    }

    /**
     * Get the code property: The error code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the message property: The error message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the target property: The error target.
     * 
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Get the additionalInfo property: The error additional info.
     * 
     * @return the additionalInfo value.
     */
    public List<ErrorAdditionalInfo> additionalInfo() {
        return this.additionalInfo;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (additionalInfo() != null) {
            additionalInfo().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentDiagnosticsDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentDiagnosticsDefinition if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeploymentDiagnosticsDefinition.
     */
    public static DeploymentDiagnosticsDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentDiagnosticsDefinition deserializedDeploymentDiagnosticsDefinition
                = new DeploymentDiagnosticsDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("level".equals(fieldName)) {
                    deserializedDeploymentDiagnosticsDefinition.level = Level.fromString(reader.getString());
                } else if ("code".equals(fieldName)) {
                    deserializedDeploymentDiagnosticsDefinition.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedDeploymentDiagnosticsDefinition.message = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedDeploymentDiagnosticsDefinition.target = reader.getString();
                } else if ("additionalInfo".equals(fieldName)) {
                    List<ErrorAdditionalInfo> additionalInfo
                        = reader.readArray(reader1 -> ErrorAdditionalInfo.fromJson(reader1));
                    deserializedDeploymentDiagnosticsDefinition.additionalInfo = additionalInfo;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentDiagnosticsDefinition;
        });
    }
}
