// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about feature.
 */
@Fluent
public final class FeatureProperties implements JsonSerializable<FeatureProperties> {
    /*
     * The registration state of the feature for the subscription.
     */
    private String state;

    /**
     * Creates an instance of FeatureProperties class.
     */
    public FeatureProperties() {
    }

    /**
     * Get the state property: The registration state of the feature for the subscription.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The registration state of the feature for the subscription.
     * 
     * @param state the state value to set.
     * @return the FeatureProperties object itself.
     */
    public FeatureProperties withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FeatureProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FeatureProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FeatureProperties.
     */
    public static FeatureProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FeatureProperties deserializedFeatureProperties = new FeatureProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedFeatureProperties.state = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFeatureProperties;
        });
    }
}
