// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluent.TagOperationsClient;
import com.azure.resourcemanager.resources.fluent.models.TagDetailsInner;
import com.azure.resourcemanager.resources.fluent.models.TagValueInner;
import com.azure.resourcemanager.resources.fluent.models.TagsResourceInner;
import com.azure.resourcemanager.resources.models.Tags;
import com.azure.resourcemanager.resources.models.TagsListResult;
import com.azure.resourcemanager.resources.models.TagsPatchResource;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in TagOperationsClient. */
public final class TagOperationsClientImpl implements TagOperationsClient {
    private final ClientLogger logger = new ClientLogger(TagOperationsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final TagOperationsService service;

    /** The service client containing this operation class. */
    private final ResourceManagementClientImpl client;

    /**
     * Initializes an instance of TagOperationsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    TagOperationsClientImpl(ResourceManagementClientImpl client) {
        this.service =
            RestProxy.create(TagOperationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ResourceManagementClientTagOperations to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ResourceManagementCl")
    private interface TagOperationsService {
        @Headers({"Content-Type: application/json"})
        @Delete("/subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> deleteValue(
            @HostParam("$host") String endpoint,
            @PathParam("tagName") String tagName,
            @PathParam("tagValue") String tagValue,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put("/subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TagValueInner>> createOrUpdateValue(
            @HostParam("$host") String endpoint,
            @PathParam("tagName") String tagName,
            @PathParam("tagValue") String tagValue,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put("/subscriptions/{subscriptionId}/tagNames/{tagName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TagDetailsInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("tagName") String tagName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/subscriptions/{subscriptionId}/tagNames/{tagName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("tagName") String tagName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/tagNames")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TagsListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put("/{scope}/providers/Microsoft.Resources/tags/default")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TagsResourceInner>> createOrUpdateAtScope(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") TagsResourceInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/{scope}/providers/Microsoft.Resources/tags/default")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TagsResourceInner>> updateAtScope(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") TagsPatchResource parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Resources/tags/default")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TagsResourceInner>> getAtScope(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/{scope}/providers/Microsoft.Resources/tags/default")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> deleteAtScope(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TagsListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * This operation allows deleting a value from the list of predefined values for an existing predefined tag name.
     * The value being deleted must not be in use as a tag value for the given tag name for any resource.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteValueWithResponseAsync(String tagName, String tagValue) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (tagName == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagName is required and cannot be null."));
        }
        if (tagValue == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagValue is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteValue(
                            this.client.getEndpoint(),
                            tagName,
                            tagValue,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation allows deleting a value from the list of predefined values for an existing predefined tag name.
     * The value being deleted must not be in use as a tag value for the given tag name for any resource.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteValueWithResponseAsync(String tagName, String tagValue, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (tagName == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagName is required and cannot be null."));
        }
        if (tagValue == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagValue is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .deleteValue(
                this.client.getEndpoint(),
                tagName,
                tagValue,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * This operation allows deleting a value from the list of predefined values for an existing predefined tag name.
     * The value being deleted must not be in use as a tag value for the given tag name for any resource.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteValueAsync(String tagName, String tagValue) {
        return deleteValueWithResponseAsync(tagName, tagValue).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * This operation allows deleting a value from the list of predefined values for an existing predefined tag name.
     * The value being deleted must not be in use as a tag value for the given tag name for any resource.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteValue(String tagName, String tagValue) {
        deleteValueAsync(tagName, tagValue).block();
    }

    /**
     * This operation allows deleting a value from the list of predefined values for an existing predefined tag name.
     * The value being deleted must not be in use as a tag value for the given tag name for any resource.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteValueWithResponse(String tagName, String tagValue, Context context) {
        return deleteValueWithResponseAsync(tagName, tagValue, context).block();
    }

    /**
     * This operation allows adding a value to the list of predefined values for an existing predefined tag name. A tag
     * value can have a maximum of 256 characters.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TagValueInner>> createOrUpdateValueWithResponseAsync(String tagName, String tagValue) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (tagName == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagName is required and cannot be null."));
        }
        if (tagValue == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagValue is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdateValue(
                            this.client.getEndpoint(),
                            tagName,
                            tagValue,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation allows adding a value to the list of predefined values for an existing predefined tag name. A tag
     * value can have a maximum of 256 characters.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TagValueInner>> createOrUpdateValueWithResponseAsync(
        String tagName, String tagValue, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (tagName == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagName is required and cannot be null."));
        }
        if (tagValue == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagValue is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdateValue(
                this.client.getEndpoint(),
                tagName,
                tagValue,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * This operation allows adding a value to the list of predefined values for an existing predefined tag name. A tag
     * value can have a maximum of 256 characters.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TagValueInner> createOrUpdateValueAsync(String tagName, String tagValue) {
        return createOrUpdateValueWithResponseAsync(tagName, tagValue)
            .flatMap(
                (Response<TagValueInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation allows adding a value to the list of predefined values for an existing predefined tag name. A tag
     * value can have a maximum of 256 characters.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TagValueInner createOrUpdateValue(String tagName, String tagValue) {
        return createOrUpdateValueAsync(tagName, tagValue).block();
    }

    /**
     * This operation allows adding a value to the list of predefined values for an existing predefined tag name. A tag
     * value can have a maximum of 256 characters.
     *
     * @param tagName The name of the tag.
     * @param tagValue The value of the tag to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TagValueInner> createOrUpdateValueWithResponse(String tagName, String tagValue, Context context) {
        return createOrUpdateValueWithResponseAsync(tagName, tagValue, context).block();
    }

    /**
     * This operation allows adding a name to the list of predefined tag names for the given subscription. A tag name
     * can have a maximum of 512 characters and is case-insensitive. Tag names cannot have the following prefixes which
     * are reserved for Azure use: 'microsoft', 'azure', 'windows'.
     *
     * @param tagName The name of the tag to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TagDetailsInner>> createOrUpdateWithResponseAsync(String tagName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (tagName == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            tagName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation allows adding a name to the list of predefined tag names for the given subscription. A tag name
     * can have a maximum of 512 characters and is case-insensitive. Tag names cannot have the following prefixes which
     * are reserved for Azure use: 'microsoft', 'azure', 'windows'.
     *
     * @param tagName The name of the tag to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TagDetailsInner>> createOrUpdateWithResponseAsync(String tagName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (tagName == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                tagName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * This operation allows adding a name to the list of predefined tag names for the given subscription. A tag name
     * can have a maximum of 512 characters and is case-insensitive. Tag names cannot have the following prefixes which
     * are reserved for Azure use: 'microsoft', 'azure', 'windows'.
     *
     * @param tagName The name of the tag to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TagDetailsInner> createOrUpdateAsync(String tagName) {
        return createOrUpdateWithResponseAsync(tagName)
            .flatMap(
                (Response<TagDetailsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation allows adding a name to the list of predefined tag names for the given subscription. A tag name
     * can have a maximum of 512 characters and is case-insensitive. Tag names cannot have the following prefixes which
     * are reserved for Azure use: 'microsoft', 'azure', 'windows'.
     *
     * @param tagName The name of the tag to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TagDetailsInner createOrUpdate(String tagName) {
        return createOrUpdateAsync(tagName).block();
    }

    /**
     * This operation allows adding a name to the list of predefined tag names for the given subscription. A tag name
     * can have a maximum of 512 characters and is case-insensitive. Tag names cannot have the following prefixes which
     * are reserved for Azure use: 'microsoft', 'azure', 'windows'.
     *
     * @param tagName The name of the tag to create.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TagDetailsInner> createOrUpdateWithResponse(String tagName, Context context) {
        return createOrUpdateWithResponseAsync(tagName, context).block();
    }

    /**
     * This operation allows deleting a name from the list of predefined tag names for the given subscription. The name
     * being deleted must not be in use as a tag name for any resource. All predefined values for the given name must
     * have already been deleted.
     *
     * @param tagName The name of the tag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String tagName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (tagName == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            tagName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation allows deleting a name from the list of predefined tag names for the given subscription. The name
     * being deleted must not be in use as a tag name for any resource. All predefined values for the given name must
     * have already been deleted.
     *
     * @param tagName The name of the tag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String tagName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (tagName == null) {
            return Mono.error(new IllegalArgumentException("Parameter tagName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                tagName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * This operation allows deleting a name from the list of predefined tag names for the given subscription. The name
     * being deleted must not be in use as a tag name for any resource. All predefined values for the given name must
     * have already been deleted.
     *
     * @param tagName The name of the tag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String tagName) {
        return deleteWithResponseAsync(tagName).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * This operation allows deleting a name from the list of predefined tag names for the given subscription. The name
     * being deleted must not be in use as a tag name for any resource. All predefined values for the given name must
     * have already been deleted.
     *
     * @param tagName The name of the tag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String tagName) {
        deleteAsync(tagName).block();
    }

    /**
     * This operation allows deleting a name from the list of predefined tag names for the given subscription. The name
     * being deleted must not be in use as a tag name for any resource. All predefined values for the given name must
     * have already been deleted.
     *
     * @param tagName The name of the tag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String tagName, Context context) {
        return deleteWithResponseAsync(tagName, context).block();
    }

    /**
     * This operation performs a union of predefined tags, resource tags, resource group tags and subscription tags, and
     * returns a summary of usage for each tag name and value under the given subscription. In case of a large number of
     * tags, this operation may return a previously cached result.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of subscription tags.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<TagDetailsInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .<PagedResponse<TagDetailsInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation performs a union of predefined tags, resource tags, resource group tags and subscription tags, and
     * returns a summary of usage for each tag name and value under the given subscription. In case of a large number of
     * tags, this operation may return a previously cached result.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of subscription tags.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<TagDetailsInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * This operation performs a union of predefined tags, resource tags, resource group tags and subscription tags, and
     * returns a summary of usage for each tag name and value under the given subscription. In case of a large number of
     * tags, this operation may return a previously cached result.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of subscription tags.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<TagDetailsInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * This operation performs a union of predefined tags, resource tags, resource group tags and subscription tags, and
     * returns a summary of usage for each tag name and value under the given subscription. In case of a large number of
     * tags, this operation may return a previously cached result.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of subscription tags.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<TagDetailsInner> listAsync(Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * This operation performs a union of predefined tags, resource tags, resource group tags and subscription tags, and
     * returns a summary of usage for each tag name and value under the given subscription. In case of a large number of
     * tags, this operation may return a previously cached result.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of subscription tags.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<TagDetailsInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * This operation performs a union of predefined tags, resource tags, resource group tags and subscription tags, and
     * returns a summary of usage for each tag name and value under the given subscription. In case of a large number of
     * tags, this operation may return a previously cached result.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of subscription tags.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<TagDetailsInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * This operation allows adding or replacing the entire set of tags on the specified resource or subscription. The
     * specified entity can have a maximum of 50 tags.
     *
     * @param scope The resource scope.
     * @param properties The set of tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TagsResourceInner>> createOrUpdateAtScopeWithResponseAsync(String scope, Tags properties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error(new IllegalArgumentException("Parameter properties is required and cannot be null."));
        } else {
            properties.validate();
        }
        final String accept = "application/json";
        TagsResourceInner parameters = new TagsResourceInner();
        parameters.withProperties(properties);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdateAtScope(
                            this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation allows adding or replacing the entire set of tags on the specified resource or subscription. The
     * specified entity can have a maximum of 50 tags.
     *
     * @param scope The resource scope.
     * @param properties The set of tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TagsResourceInner>> createOrUpdateAtScopeWithResponseAsync(
        String scope, Tags properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error(new IllegalArgumentException("Parameter properties is required and cannot be null."));
        } else {
            properties.validate();
        }
        final String accept = "application/json";
        TagsResourceInner parameters = new TagsResourceInner();
        parameters.withProperties(properties);
        context = this.client.mergeContext(context);
        return service
            .createOrUpdateAtScope(
                this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * This operation allows adding or replacing the entire set of tags on the specified resource or subscription. The
     * specified entity can have a maximum of 50 tags.
     *
     * @param scope The resource scope.
     * @param properties The set of tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TagsResourceInner> createOrUpdateAtScopeAsync(String scope, Tags properties) {
        return createOrUpdateAtScopeWithResponseAsync(scope, properties)
            .flatMap(
                (Response<TagsResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation allows adding or replacing the entire set of tags on the specified resource or subscription. The
     * specified entity can have a maximum of 50 tags.
     *
     * @param scope The resource scope.
     * @param properties The set of tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TagsResourceInner createOrUpdateAtScope(String scope, Tags properties) {
        return createOrUpdateAtScopeAsync(scope, properties).block();
    }

    /**
     * This operation allows adding or replacing the entire set of tags on the specified resource or subscription. The
     * specified entity can have a maximum of 50 tags.
     *
     * @param scope The resource scope.
     * @param properties The set of tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TagsResourceInner> createOrUpdateAtScopeWithResponse(
        String scope, Tags properties, Context context) {
        return createOrUpdateAtScopeWithResponseAsync(scope, properties, context).block();
    }

    /**
     * This operation allows replacing, merging or selectively deleting tags on the specified resource or subscription.
     * The specified entity can have a maximum of 50 tags at the end of the operation. The 'replace' option replaces the
     * entire set of existing tags with a new set. The 'merge' option allows adding tags with new names and updating the
     * values of tags with existing names. The 'delete' option allows selectively deleting tags based on given names or
     * name/value pairs.
     *
     * @param scope The resource scope.
     * @param parameters Wrapper resource for tags patch API request only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TagsResourceInner>> updateAtScopeWithResponseAsync(
        String scope, TagsPatchResource parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateAtScope(
                            this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * This operation allows replacing, merging or selectively deleting tags on the specified resource or subscription.
     * The specified entity can have a maximum of 50 tags at the end of the operation. The 'replace' option replaces the
     * entire set of existing tags with a new set. The 'merge' option allows adding tags with new names and updating the
     * values of tags with existing names. The 'delete' option allows selectively deleting tags based on given names or
     * name/value pairs.
     *
     * @param scope The resource scope.
     * @param parameters Wrapper resource for tags patch API request only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TagsResourceInner>> updateAtScopeWithResponseAsync(
        String scope, TagsPatchResource parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateAtScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * This operation allows replacing, merging or selectively deleting tags on the specified resource or subscription.
     * The specified entity can have a maximum of 50 tags at the end of the operation. The 'replace' option replaces the
     * entire set of existing tags with a new set. The 'merge' option allows adding tags with new names and updating the
     * values of tags with existing names. The 'delete' option allows selectively deleting tags based on given names or
     * name/value pairs.
     *
     * @param scope The resource scope.
     * @param parameters Wrapper resource for tags patch API request only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TagsResourceInner> updateAtScopeAsync(String scope, TagsPatchResource parameters) {
        return updateAtScopeWithResponseAsync(scope, parameters)
            .flatMap(
                (Response<TagsResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * This operation allows replacing, merging or selectively deleting tags on the specified resource or subscription.
     * The specified entity can have a maximum of 50 tags at the end of the operation. The 'replace' option replaces the
     * entire set of existing tags with a new set. The 'merge' option allows adding tags with new names and updating the
     * values of tags with existing names. The 'delete' option allows selectively deleting tags based on given names or
     * name/value pairs.
     *
     * @param scope The resource scope.
     * @param parameters Wrapper resource for tags patch API request only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TagsResourceInner updateAtScope(String scope, TagsPatchResource parameters) {
        return updateAtScopeAsync(scope, parameters).block();
    }

    /**
     * This operation allows replacing, merging or selectively deleting tags on the specified resource or subscription.
     * The specified entity can have a maximum of 50 tags at the end of the operation. The 'replace' option replaces the
     * entire set of existing tags with a new set. The 'merge' option allows adding tags with new names and updating the
     * values of tags with existing names. The 'delete' option allows selectively deleting tags based on given names or
     * name/value pairs.
     *
     * @param scope The resource scope.
     * @param parameters Wrapper resource for tags patch API request only.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper resource for tags API requests and responses.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TagsResourceInner> updateAtScopeWithResponse(
        String scope, TagsPatchResource parameters, Context context) {
        return updateAtScopeWithResponseAsync(scope, parameters, context).block();
    }

    /**
     * Gets the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entire set of tags on a resource or subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TagsResourceInner>> getAtScopeWithResponseAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.getAtScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entire set of tags on a resource or subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TagsResourceInner>> getAtScopeWithResponseAsync(String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAtScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entire set of tags on a resource or subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TagsResourceInner> getAtScopeAsync(String scope) {
        return getAtScopeWithResponseAsync(scope)
            .flatMap(
                (Response<TagsResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entire set of tags on a resource or subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TagsResourceInner getAtScope(String scope) {
        return getAtScopeAsync(scope).block();
    }

    /**
     * Gets the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entire set of tags on a resource or subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TagsResourceInner> getAtScopeWithResponse(String scope, Context context) {
        return getAtScopeWithResponseAsync(scope, context).block();
    }

    /**
     * Deletes the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAtScopeWithResponseAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteAtScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtScopeWithResponseAsync(String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAtScope(this.client.getEndpoint(), scope, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtScopeAsync(String scope) {
        return deleteAtScopeWithResponseAsync(scope).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Deletes the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtScope(String scope) {
        deleteAtScopeAsync(scope).block();
    }

    /**
     * Deletes the entire set of tags on a resource or subscription.
     *
     * @param scope The resource scope.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAtScopeWithResponse(String scope, Context context) {
        return deleteAtScopeWithResponseAsync(scope, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of subscription tags.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<TagDetailsInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<TagDetailsInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of subscription tags.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<TagDetailsInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
