/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Locale;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class AuthenticationPolicy
implements HttpPipelinePolicy {
    private static final String AUTHORIZATION_HEADER_KEY = "Authorization";
    private static final String AUTHORIZATION_HEADER_VALUE_FORMAT = "Bearer %s";
    private final TokenCredential credential;
    private final String[] scopes;
    private final AzureEnvironment environment;

    public AuthenticationPolicy(TokenCredential credential, AzureEnvironment environment, String ... scopes) {
        Objects.requireNonNull(credential);
        this.credential = credential;
        this.environment = environment;
        this.scopes = scopes;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Mono tokenResult;
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol().toLowerCase(Locale.ROOT))) {
            return Mono.error((Throwable)new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        if (this.scopes == null || this.scopes.length == 0) {
            String defaultScope = ResourceManagerUtils.getDefaultScopeFromRequest(context.getHttpRequest(), this.environment);
            tokenResult = this.credential.getToken(new TokenRequestContext().addScopes(new String[]{defaultScope}));
        } else {
            tokenResult = this.credential.getToken(new TokenRequestContext().addScopes(this.scopes));
        }
        return tokenResult.flatMap(accessToken -> {
            context.getHttpRequest().getHeaders().set(AUTHORIZATION_HEADER_KEY, String.format(AUTHORIZATION_HEADER_VALUE_FORMAT, accessToken.getToken()));
            return next.process();
        });
    }
}

