/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.ResourcesClient;
import com.azure.resourcemanager.resources.fluent.models.GenericResourceExpandedInner;
import com.azure.resourcemanager.resources.fluent.models.GenericResourceInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.implementation.ResourceManagementClientImpl;
import com.azure.resourcemanager.resources.models.ResourceListResult;
import com.azure.resourcemanager.resources.models.ResourcesMoveInfo;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ResourcesClientImpl
implements InnerSupportsListing<GenericResourceExpandedInner>,
ResourcesClient {
    private final ClientLogger logger = new ClientLogger(ResourcesClientImpl.class);
    private final ResourcesService service;
    private final ResourceManagementClientImpl client;

    ResourcesClientImpl(ResourceManagementClientImpl client) {
        this.service = (ResourcesService)RestProxy.create(ResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, filter, expand, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResult)res.getValue()).value(), ((ResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, filter, expand, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResult)res.getValue()).value(), ((ResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GenericResourceExpandedInner> listByResourceGroupAsync(String resourceGroupName, String filter, String expand, Integer top) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GenericResourceExpandedInner> listByResourceGroupAsync(String resourceGroupName) {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GenericResourceExpandedInner> listByResourceGroupAsync(String resourceGroupName, String filter, String expand, Integer top, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, filter, expand, top, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GenericResourceExpandedInner> listByResourceGroup(String resourceGroupName) {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, expand, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GenericResourceExpandedInner> listByResourceGroup(String resourceGroupName, String filter, String expand, Integer top, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, filter, expand, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> moveResourcesWithResponseAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sourceResourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.moveResources(this.client.getEndpoint(), sourceResourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> moveResourcesWithResponseAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sourceResourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.moveResources(this.client.getEndpoint(), sourceResourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.moveResourcesWithResponseAsync(sourceResourceGroupName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.moveResourcesWithResponseAsync(sourceResourceGroupName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return this.beginMoveResourcesAsync(sourceResourceGroupName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        return this.beginMoveResourcesAsync(sourceResourceGroupName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> moveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return this.beginMoveResourcesAsync(sourceResourceGroupName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> moveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        return this.beginMoveResourcesAsync(sourceResourceGroupName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void moveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        this.moveResourcesAsync(sourceResourceGroupName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void moveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        this.moveResourcesAsync(sourceResourceGroupName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateMoveResourcesWithResponseAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sourceResourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateMoveResources(this.client.getEndpoint(), sourceResourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateMoveResourcesWithResponseAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (sourceResourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceResourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateMoveResources(this.client.getEndpoint(), sourceResourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginValidateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateMoveResourcesWithResponseAsync(sourceResourceGroupName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginValidateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateMoveResourcesWithResponseAsync(sourceResourceGroupName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginValidateMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return this.beginValidateMoveResourcesAsync(sourceResourceGroupName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginValidateMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        return this.beginValidateMoveResourcesAsync(sourceResourceGroupName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        return this.beginValidateMoveResourcesAsync(sourceResourceGroupName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> validateMoveResourcesAsync(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        return this.beginValidateMoveResourcesAsync(sourceResourceGroupName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validateMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters) {
        this.validateMoveResourcesAsync(sourceResourceGroupName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validateMoveResources(String sourceResourceGroupName, ResourcesMoveInfo parameters, Context context) {
        this.validateMoveResourcesAsync(sourceResourceGroupName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listSinglePageAsync(String filter, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, expand, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResult)res.getValue()).value(), ((ResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listSinglePageAsync(String filter, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, expand, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResult)res.getValue()).value(), ((ResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GenericResourceExpandedInner> listAsync(String filter, String expand, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, expand, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GenericResourceExpandedInner> listAsync() {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, expand, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GenericResourceExpandedInner> listAsync(String filter, String expand, Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, expand, top, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GenericResourceExpandedInner> list() {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedIterable(this.listAsync(filter, expand, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GenericResourceExpandedInner> list(String filter, String expand, Integer top, Context context) {
        return new PagedIterable(this.listAsync(filter, expand, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkExistence(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkExistence(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return this.checkExistenceWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean checkExistence(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        Boolean value = (Boolean)this.checkExistenceAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).block();
        if (value != null) {
            return value;
        }
        throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkExistenceWithResponse(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        return (Response)this.checkExistenceWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return this.beginDeleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return this.beginDeleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        this.deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        this.deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenericResourceInner.class), (Type)((Object)GenericResourceInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenericResourceInner.class), (Type)((Object)GenericResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GenericResourceInner> createOrUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GenericResourceInner> createOrUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner createOrUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner createOrUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        return (GenericResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenericResourceInner.class), (Type)((Object)GenericResourceInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenericResourceInner.class), (Type)((Object)GenericResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdate(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GenericResourceInner> updateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GenericResourceInner> updateAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner update(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)this.updateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner update(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, GenericResourceInner parameters, Context context) {
        return (GenericResourceInner)((Object)this.updateAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GenericResourceInner>> getWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GenericResourceInner>> getWithResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceProviderNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null."));
        }
        if (parentResourcePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null."));
        }
        if (resourceType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceType is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GenericResourceInner> getAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return this.getWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((GenericResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner get(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return (GenericResourceInner)((Object)this.getAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GenericResourceInner> getWithResponse(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceByIdWithResponseAsync(String resourceId, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkExistenceById(this.client.getEndpoint(), resourceId, apiVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceByIdWithResponseAsync(String resourceId, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkExistenceById(this.client.getEndpoint(), resourceId, apiVersion, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceByIdAsync(String resourceId, String apiVersion) {
        return this.checkExistenceByIdWithResponseAsync(resourceId, apiVersion).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean checkExistenceById(String resourceId, String apiVersion) {
        Boolean value = (Boolean)this.checkExistenceByIdAsync(resourceId, apiVersion).block();
        if (value != null) {
            return value;
        }
        throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> checkExistenceByIdWithResponse(String resourceId, String apiVersion, Context context) {
        return (Response)this.checkExistenceByIdWithResponseAsync(resourceId, apiVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteByIdWithResponseAsync(String resourceId, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteById(this.client.getEndpoint(), resourceId, apiVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteByIdWithResponseAsync(String resourceId, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteById(this.client.getEndpoint(), resourceId, apiVersion, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteByIdAsync(String resourceId, String apiVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteByIdWithResponseAsync(resourceId, apiVersion);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteByIdAsync(String resourceId, String apiVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteByIdWithResponseAsync(resourceId, apiVersion, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDeleteById(String resourceId, String apiVersion) {
        return this.beginDeleteByIdAsync(resourceId, apiVersion).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDeleteById(String resourceId, String apiVersion, Context context) {
        return this.beginDeleteByIdAsync(resourceId, apiVersion, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteByIdAsync(String resourceId, String apiVersion) {
        return this.beginDeleteByIdAsync(resourceId, apiVersion).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteByIdAsync(String resourceId, String apiVersion, Context context) {
        return this.beginDeleteByIdAsync(resourceId, apiVersion, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteById(String resourceId, String apiVersion) {
        this.deleteByIdAsync(resourceId, apiVersion).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteById(String resourceId, String apiVersion, Context context) {
        this.deleteByIdAsync(resourceId, apiVersion, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateByIdWithResponseAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateById(this.client.getEndpoint(), resourceId, apiVersion, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateByIdWithResponseAsync(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateById(this.client.getEndpoint(), resourceId, apiVersion, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateByIdWithResponseAsync(resourceId, apiVersion, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenericResourceInner.class), (Type)((Object)GenericResourceInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateByIdWithResponseAsync(resourceId, apiVersion, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenericResourceInner.class), (Type)((Object)GenericResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return this.beginCreateOrUpdateByIdAsync(resourceId, apiVersion, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginCreateOrUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return this.beginCreateOrUpdateByIdAsync(resourceId, apiVersion, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GenericResourceInner> createOrUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return this.beginCreateOrUpdateByIdAsync(resourceId, apiVersion, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GenericResourceInner> createOrUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return this.beginCreateOrUpdateByIdAsync(resourceId, apiVersion, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner createOrUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)this.createOrUpdateByIdAsync(resourceId, apiVersion, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner createOrUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return (GenericResourceInner)((Object)this.createOrUpdateByIdAsync(resourceId, apiVersion, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateByIdWithResponseAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateById(this.client.getEndpoint(), resourceId, apiVersion, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateByIdWithResponseAsync(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateById(this.client.getEndpoint(), resourceId, apiVersion, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateByIdWithResponseAsync(resourceId, apiVersion, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenericResourceInner.class), (Type)((Object)GenericResourceInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateByIdWithResponseAsync(resourceId, apiVersion, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)GenericResourceInner.class), (Type)((Object)GenericResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return this.beginUpdateByIdAsync(resourceId, apiVersion, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<GenericResourceInner>, GenericResourceInner> beginUpdateById(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return this.beginUpdateByIdAsync(resourceId, apiVersion, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GenericResourceInner> updateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return this.beginUpdateByIdAsync(resourceId, apiVersion, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GenericResourceInner> updateByIdAsync(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return this.beginUpdateByIdAsync(resourceId, apiVersion, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner updateById(String resourceId, String apiVersion, GenericResourceInner parameters) {
        return (GenericResourceInner)((Object)this.updateByIdAsync(resourceId, apiVersion, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner updateById(String resourceId, String apiVersion, GenericResourceInner parameters, Context context) {
        return (GenericResourceInner)((Object)this.updateByIdAsync(resourceId, apiVersion, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GenericResourceInner>> getByIdWithResponseAsync(String resourceId, String apiVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getById(this.client.getEndpoint(), resourceId, apiVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GenericResourceInner>> getByIdWithResponseAsync(String resourceId, String apiVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (apiVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiVersion is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getById(this.client.getEndpoint(), resourceId, apiVersion, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GenericResourceInner> getByIdAsync(String resourceId, String apiVersion) {
        return this.getByIdWithResponseAsync(resourceId, apiVersion).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((GenericResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenericResourceInner getById(String resourceId, String apiVersion) {
        return (GenericResourceInner)((Object)this.getByIdAsync(resourceId, apiVersion).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GenericResourceInner> getByIdWithResponse(String resourceId, String apiVersion, Context context) {
        return (Response)this.getByIdWithResponseAsync(resourceId, apiVersion, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResult)res.getValue()).value(), ((ResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResult)res.getValue()).value(), ((ResourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResult)res.getValue()).value(), ((ResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GenericResourceExpandedInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceListResult)res.getValue()).value(), ((ResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ResourceManagementCl")
    private static interface ResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="$expand") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> moveResources(@HostParam(value="$host") String var1, @PathParam(value="sourceResourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") ResourcesMoveInfo var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateMoveResources(@HostParam(value="$host") String var1, @PathParam(value="sourceResourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") ResourcesMoveInfo var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="$expand") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Boolean>> checkExistence(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="resourceProviderNamespace") String var3, @PathParam(value="parentResourcePath", encoded=true) String var4, @PathParam(value="resourceType", encoded=true) String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="resourceProviderNamespace") String var3, @PathParam(value="parentResourcePath", encoded=true) String var4, @PathParam(value="resourceType", encoded=true) String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="resourceProviderNamespace") String var3, @PathParam(value="parentResourcePath", encoded=true) String var4, @PathParam(value="resourceType", encoded=true) String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") GenericResourceInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="resourceProviderNamespace") String var3, @PathParam(value="parentResourcePath", encoded=true) String var4, @PathParam(value="resourceType", encoded=true) String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") GenericResourceInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GenericResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="resourceProviderNamespace") String var3, @PathParam(value="parentResourcePath", encoded=true) String var4, @PathParam(value="resourceType", encoded=true) String var5, @PathParam(value="resourceName") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Head(value="/{resourceId}")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Boolean>> checkExistenceById(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{resourceId}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteById(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceId}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateById(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") GenericResourceInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/{resourceId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateById(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") GenericResourceInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GenericResourceInner>> getById(@HostParam(value="$host") String var1, @PathParam(value="resourceId", encoded=true) String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

