// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentOperationProperties;
import java.io.IOException;

/**
 * Deployment operation information.
 */
@Fluent
public final class DeploymentOperationInner implements JsonSerializable<DeploymentOperationInner> {
    /*
     * Full deployment operation ID.
     */
    private String id;

    /*
     * Deployment operation ID.
     */
    private String operationId;

    /*
     * Deployment properties.
     */
    private DeploymentOperationProperties properties;

    /**
     * Creates an instance of DeploymentOperationInner class.
     */
    public DeploymentOperationInner() {
    }

    /**
     * Get the id property: Full deployment operation ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the operationId property: Deployment operation ID.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.operationId;
    }

    /**
     * Get the properties property: Deployment properties.
     * 
     * @return the properties value.
     */
    public DeploymentOperationProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Deployment properties.
     * 
     * @param properties the properties value to set.
     * @return the DeploymentOperationInner object itself.
     */
    public DeploymentOperationInner withProperties(DeploymentOperationProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentOperationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentOperationInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentOperationInner.
     */
    public static DeploymentOperationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentOperationInner deserializedDeploymentOperationInner = new DeploymentOperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeploymentOperationInner.id = reader.getString();
                } else if ("operationId".equals(fieldName)) {
                    deserializedDeploymentOperationInner.operationId = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDeploymentOperationInner.properties = DeploymentOperationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentOperationInner;
        });
    }
}
