// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.LockLevel;
import com.azure.resourcemanager.resources.models.ManagementLockOwner;
import java.io.IOException;
import java.util.List;

/**
 * The lock information.
 */
@Fluent
public final class ManagementLockObjectInner extends ProxyResource {
    /*
     * The properties of the lock.
     */
    private ManagementLockProperties innerProperties = new ManagementLockProperties();

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ManagementLockObjectInner class.
     */
    public ManagementLockObjectInner() {
    }

    /**
     * Get the innerProperties property: The properties of the lock.
     * 
     * @return the innerProperties value.
     */
    private ManagementLockProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the level property: The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly.
     * CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means
     * authorized users can only read from a resource, but they can't modify or delete it.
     * 
     * @return the level value.
     */
    public LockLevel level() {
        return this.innerProperties() == null ? null : this.innerProperties().level();
    }

    /**
     * Set the level property: The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly.
     * CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means
     * authorized users can only read from a resource, but they can't modify or delete it.
     * 
     * @param level the level value to set.
     * @return the ManagementLockObjectInner object itself.
     */
    public ManagementLockObjectInner withLevel(LockLevel level) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementLockProperties();
        }
        this.innerProperties().withLevel(level);
        return this;
    }

    /**
     * Get the notes property: Notes about the lock. Maximum of 512 characters.
     * 
     * @return the notes value.
     */
    public String notes() {
        return this.innerProperties() == null ? null : this.innerProperties().notes();
    }

    /**
     * Set the notes property: Notes about the lock. Maximum of 512 characters.
     * 
     * @param notes the notes value to set.
     * @return the ManagementLockObjectInner object itself.
     */
    public ManagementLockObjectInner withNotes(String notes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementLockProperties();
        }
        this.innerProperties().withNotes(notes);
        return this;
    }

    /**
     * Get the owners property: The owners of the lock.
     * 
     * @return the owners value.
     */
    public List<ManagementLockOwner> owners() {
        return this.innerProperties() == null ? null : this.innerProperties().owners();
    }

    /**
     * Set the owners property: The owners of the lock.
     * 
     * @param owners the owners value to set.
     * @return the ManagementLockObjectInner object itself.
     */
    public ManagementLockObjectInner withOwners(List<ManagementLockOwner> owners) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementLockProperties();
        }
        this.innerProperties().withOwners(owners);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model ManagementLockObjectInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagementLockObjectInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagementLockObjectInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagementLockObjectInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagementLockObjectInner.
     */
    public static ManagementLockObjectInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementLockObjectInner deserializedManagementLockObjectInner = new ManagementLockObjectInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagementLockObjectInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagementLockObjectInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagementLockObjectInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagementLockObjectInner.innerProperties = ManagementLockProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagementLockObjectInner;
        });
    }
}
