// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluent.DeploymentsClient;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExportResultInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExtendedInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentValidateResultInner;
import com.azure.resourcemanager.resources.fluent.models.TemplateHashResultInner;
import com.azure.resourcemanager.resources.fluent.models.WhatIfOperationResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.models.DeploymentListResult;
import com.azure.resourcemanager.resources.models.DeploymentWhatIf;
import com.azure.resourcemanager.resources.models.ScopedDeployment;
import com.azure.resourcemanager.resources.models.ScopedDeploymentWhatIf;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DeploymentsClient.
 */
public final class DeploymentsClientImpl implements InnerSupportsGet<DeploymentExtendedInner>,
    InnerSupportsListing<DeploymentExtendedInner>, InnerSupportsDelete<Void>, DeploymentsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DeploymentsService service;

    /**
     * The service client containing this operation class.
     */
    private final ResourceManagementClientImpl client;

    /**
     * Initializes an instance of DeploymentsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    DeploymentsClientImpl(ResourceManagementClientImpl client) {
        this.service
            = RestProxy.create(DeploymentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ResourceManagementClientDeployments to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ResourceManagementCl")
    public interface DeploymentsService {
        @Headers({ "Content-Type: application/json" })
        @Delete("/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteAtScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Head("/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Boolean>> checkExistenceAtScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExtendedInner>> getAtScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> cancelAtScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses({ 200, 202, 400 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validateAtScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExportResultInner>> exportTemplateAtScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/{scope}/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listAtScope(@HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope, @QueryParam("$filter") String filter,
            @QueryParam("$top") Integer top, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteAtTenantScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Head("/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Boolean>> checkExistenceAtTenantScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtTenantScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ScopedDeployment parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExtendedInner>> getAtTenantScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> cancelAtTenantScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses({ 200, 202, 400 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validateAtTenantScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ScopedDeployment parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> whatIfAtTenantScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ScopedDeploymentWhatIf parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExportResultInner>> exportTemplateAtTenantScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listAtTenantScope(@HostParam("$host") String endpoint,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupScope(@HostParam("$host") String endpoint,
            @PathParam("groupId") String groupId, @PathParam("deploymentName") String deploymentName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Head("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Boolean>> checkExistenceAtManagementGroupScope(@HostParam("$host") String endpoint,
            @PathParam("groupId") String groupId, @PathParam("deploymentName") String deploymentName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupScope(@HostParam("$host") String endpoint,
            @PathParam("groupId") String groupId, @PathParam("deploymentName") String deploymentName,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") ScopedDeployment parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExtendedInner>> getAtManagementGroupScope(@HostParam("$host") String endpoint,
            @PathParam("groupId") String groupId, @PathParam("deploymentName") String deploymentName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> cancelAtManagementGroupScope(@HostParam("$host") String endpoint,
            @PathParam("groupId") String groupId, @PathParam("deploymentName") String deploymentName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses({ 200, 202, 400 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validateAtManagementGroupScope(@HostParam("$host") String endpoint,
            @PathParam("groupId") String groupId, @PathParam("deploymentName") String deploymentName,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") ScopedDeployment parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> whatIfAtManagementGroupScope(@HostParam("$host") String endpoint,
            @PathParam("groupId") String groupId, @PathParam("deploymentName") String deploymentName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ScopedDeploymentWhatIf parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExportResultInner>> exportTemplateAtManagementGroupScope(
            @HostParam("$host") String endpoint, @PathParam("groupId") String groupId,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listAtManagementGroupScope(@HostParam("$host") String endpoint,
            @PathParam("groupId") String groupId, @QueryParam("$filter") String filter, @QueryParam("$top") Integer top,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Head("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Boolean>> checkExistenceAtSubscriptionScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") DeploymentInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExtendedInner>> getAtSubscriptionScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> cancelAtSubscriptionScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses({ 200, 202, 400 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validateAtSubscriptionScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") DeploymentInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> whatIfAtSubscriptionScope(@HostParam("$host") String endpoint,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") DeploymentWhatIf parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExportResultInner>> exportTemplateAtSubscriptionScope(
            @HostParam("$host") String endpoint, @PathParam("deploymentName") String deploymentName,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> list(@HostParam("$host") String endpoint,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Head("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 204, 404 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Boolean>> checkExistence(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") DeploymentInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExtendedInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> cancel(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate")
        @ExpectedResponses({ 200, 202, 400 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") DeploymentInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> whatIf(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") DeploymentWhatIf parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentExportResultInner>> exportTemplate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentName") String deploymentName, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("$filter") String filter,
            @QueryParam("$top") Integer top, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Resources/calculateTemplateHash")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TemplateHashResultInner>> calculateTemplateHash(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") Object template,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listAtScopeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listAtTenantScopeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listAtManagementGroupScopeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listAtSubscriptionScopeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentListResult>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteAtScope(this.client.getEndpoint(), scope, deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtScopeWithResponseAsync(String scope, String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtScopeAsync(String scope, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAtScopeWithResponseAsync(scope, deploymentName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtScopeAsync(String scope, String deploymentName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAtScopeWithResponseAsync(scope, deploymentName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtScope(String scope, String deploymentName) {
        return this.beginDeleteAtScopeAsync(scope, deploymentName).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtScope(String scope, String deploymentName, Context context) {
        return this.beginDeleteAtScopeAsync(scope, deploymentName, context).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtScopeAsync(String scope, String deploymentName) {
        return beginDeleteAtScopeAsync(scope, deploymentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAtScopeAsync(String scope, String deploymentName, Context context) {
        return beginDeleteAtScopeAsync(scope, deploymentName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtScope(String scope, String deploymentName) {
        deleteAtScopeAsync(scope, deploymentName).block();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtScope(String scope, String deploymentName, Context context) {
        deleteAtScopeAsync(scope, deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.checkExistenceAtScope(this.client.getEndpoint(), scope, deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceAtScopeWithResponseAsync(String scope, String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkExistenceAtScope(this.client.getEndpoint(), scope, deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAtScopeAsync(String scope, String deploymentName) {
        return checkExistenceAtScopeWithResponseAsync(scope, deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> checkExistenceAtScopeWithResponse(String scope, String deploymentName, Context context) {
        return checkExistenceAtScopeWithResponseAsync(scope, deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean checkExistenceAtScope(String scope, String deploymentName) {
        return checkExistenceAtScopeWithResponse(scope, deploymentName, Context.NONE).getValue();
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtScopeWithResponseAsync(String scope, String deploymentName,
        DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateAtScope(this.client.getEndpoint(), scope, deploymentName,
                this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtScopeWithResponseAsync(String scope, String deploymentName,
        DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateAtScope(this.client.getEndpoint(), scope, deploymentName,
            this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtScopeWithResponseAsync(scope, deploymentName, parameters);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class,
            this.client.getContext());
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAtScopeAsync(
        String scope, String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtScopeWithResponseAsync(scope, deploymentName, parameters, context);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class, context);
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAtScopeAsync(scope, deploymentName, parameters).getSyncPoller();
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtScope(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAtScopeAsync(scope, deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAtScopeAsync(String scope, String deploymentName,
        DeploymentInner parameters) {
        return beginCreateOrUpdateAtScopeAsync(scope, deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAtScopeAsync(String scope, String deploymentName,
        DeploymentInner parameters, Context context) {
        return beginCreateOrUpdateAtScopeAsync(scope, deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtScope(String scope, String deploymentName,
        DeploymentInner parameters) {
        return createOrUpdateAtScopeAsync(scope, deploymentName, parameters).block();
    }

    /**
     * Deploys resources at a given scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtScope(String scope, String deploymentName,
        DeploymentInner parameters, Context context) {
        return createOrUpdateAtScopeAsync(scope, deploymentName, parameters, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAtScope(this.client.getEndpoint(), scope, deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getAtScopeWithResponseAsync(String scope, String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets a deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getAtScopeAsync(String scope, String deploymentName) {
        return getAtScopeWithResponseAsync(scope, deploymentName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getAtScopeWithResponse(String scope, String deploymentName,
        Context context) {
        return getAtScopeWithResponseAsync(scope, deploymentName, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner getAtScope(String scope, String deploymentName) {
        return getAtScopeWithResponse(scope, deploymentName, Context.NONE).getValue();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAtScopeWithResponseAsync(String scope, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.cancelAtScope(this.client.getEndpoint(), scope, deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> cancelAtScopeWithResponseAsync(String scope, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.cancelAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelAtScopeAsync(String scope, String deploymentName) {
        return cancelAtScopeWithResponseAsync(scope, deploymentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> cancelAtScopeWithResponse(String scope, String deploymentName, Context context) {
        return cancelAtScopeWithResponseAsync(scope, deploymentName, context).block();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void cancelAtScope(String scope, String deploymentName) {
        cancelAtScopeWithResponse(scope, deploymentName, Context.NONE);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateAtScopeWithResponseAsync(String scope, String deploymentName,
        DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateAtScope(this.client.getEndpoint(), scope, deploymentName,
                this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateAtScopeWithResponseAsync(String scope, String deploymentName,
        DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateAtScope(this.client.getEndpoint(), scope, deploymentName, this.client.getApiVersion(),
            parameters, accept, context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = validateAtScopeWithResponseAsync(scope, deploymentName, parameters);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            this.client.getContext());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtScopeAsync(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateAtScopeWithResponseAsync(scope, deploymentName, parameters, context);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtScope(String scope, String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAtScopeAsync(scope, deploymentName, parameters).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtScope(String scope, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAtScopeAsync(scope, deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAtScopeAsync(String scope, String deploymentName,
        DeploymentInner parameters) {
        return beginValidateAtScopeAsync(scope, deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAtScopeAsync(String scope, String deploymentName,
        DeploymentInner parameters, Context context) {
        return beginValidateAtScopeAsync(scope, deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtScope(String scope, String deploymentName,
        DeploymentInner parameters) {
        return validateAtScopeAsync(scope, deploymentName, parameters).block();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtScope(String scope, String deploymentName,
        DeploymentInner parameters, Context context) {
        return validateAtScopeAsync(scope, deploymentName, parameters, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>> exportTemplateAtScopeWithResponseAsync(String scope,
        String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.exportTemplateAtScope(this.client.getEndpoint(), scope, deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>> exportTemplateAtScopeWithResponseAsync(String scope,
        String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.exportTemplateAtScope(this.client.getEndpoint(), scope, deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAtScopeAsync(String scope, String deploymentName) {
        return exportTemplateAtScopeWithResponseAsync(scope, deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateAtScopeWithResponse(String scope, String deploymentName,
        Context context) {
        return exportTemplateAtScopeWithResponseAsync(scope, deploymentName, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param scope The resource scope.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplateAtScope(String scope, String deploymentName) {
        return exportTemplateAtScopeWithResponse(scope, deploymentName, Context.NONE).getValue();
    }

    /**
     * Get all the deployments at the given scope.
     * 
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtScopeSinglePageAsync(String scope, String filter,
        Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAtScope(this.client.getEndpoint(), scope, filter, top,
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all the deployments at the given scope.
     * 
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtScopeSinglePageAsync(String scope, String filter,
        Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAtScope(this.client.getEndpoint(), scope, filter, top, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all the deployments at the given scope.
     * 
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtScopeAsync(String scope, String filter, Integer top) {
        return new PagedFlux<>(() -> listAtScopeSinglePageAsync(scope, filter, top),
            nextLink -> listAtScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments at the given scope.
     * 
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtScopeAsync(String scope) {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listAtScopeSinglePageAsync(scope, filter, top),
            nextLink -> listAtScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments at the given scope.
     * 
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listAtScopeAsync(String scope, String filter, Integer top,
        Context context) {
        return new PagedFlux<>(() -> listAtScopeSinglePageAsync(scope, filter, top, context),
            nextLink -> listAtScopeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all the deployments at the given scope.
     * 
     * @param scope The resource scope.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtScope(String scope) {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listAtScopeAsync(scope, filter, top));
    }

    /**
     * Get all the deployments at the given scope.
     * 
     * @param scope The resource scope.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the given scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtScope(String scope, String filter, Integer top,
        Context context) {
        return new PagedIterable<>(listAtScopeAsync(scope, filter, top, context));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteAtTenantScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtTenantScopeWithResponseAsync(String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtTenantScopeAsync(String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAtTenantScopeWithResponseAsync(deploymentName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtTenantScopeAsync(String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAtTenantScopeWithResponseAsync(deploymentName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtTenantScope(String deploymentName) {
        return this.beginDeleteAtTenantScopeAsync(deploymentName).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtTenantScope(String deploymentName, Context context) {
        return this.beginDeleteAtTenantScopeAsync(deploymentName, context).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtTenantScopeAsync(String deploymentName) {
        return beginDeleteAtTenantScopeAsync(deploymentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAtTenantScopeAsync(String deploymentName, Context context) {
        return beginDeleteAtTenantScopeAsync(deploymentName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtTenantScope(String deploymentName) {
        deleteAtTenantScopeAsync(deploymentName).block();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtTenantScope(String deploymentName, Context context) {
        deleteAtTenantScopeAsync(deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.checkExistenceAtTenantScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceAtTenantScopeWithResponseAsync(String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkExistenceAtTenantScope(this.client.getEndpoint(), deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAtTenantScopeAsync(String deploymentName) {
        return checkExistenceAtTenantScopeWithResponseAsync(deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> checkExistenceAtTenantScopeWithResponse(String deploymentName, Context context) {
        return checkExistenceAtTenantScopeWithResponseAsync(deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean checkExistenceAtTenantScope(String deploymentName) {
        return checkExistenceAtTenantScopeWithResponse(deploymentName, Context.NONE).getValue();
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtTenantScopeWithResponseAsync(String deploymentName,
        ScopedDeployment parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateAtTenantScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtTenantScopeWithResponseAsync(String deploymentName,
        ScopedDeployment parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateAtTenantScope(this.client.getEndpoint(), deploymentName,
            this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtTenantScopeWithResponseAsync(deploymentName, parameters);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class,
            this.client.getContext());
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtTenantScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class, context);
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return this.beginCreateOrUpdateAtTenantScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginCreateOrUpdateAtTenantScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName,
        ScopedDeployment parameters) {
        return beginCreateOrUpdateAtTenantScopeAsync(deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAtTenantScopeAsync(String deploymentName,
        ScopedDeployment parameters, Context context) {
        return beginCreateOrUpdateAtTenantScopeAsync(deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return createOrUpdateAtTenantScopeAsync(deploymentName, parameters).block();
    }

    /**
     * Deploys resources at tenant scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtTenantScope(String deploymentName, ScopedDeployment parameters,
        Context context) {
        return createOrUpdateAtTenantScopeAsync(deploymentName, parameters, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAtTenantScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getAtTenantScopeWithResponseAsync(String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getAtTenantScopeAsync(String deploymentName) {
        return getAtTenantScopeWithResponseAsync(deploymentName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getAtTenantScopeWithResponse(String deploymentName, Context context) {
        return getAtTenantScopeWithResponseAsync(deploymentName, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner getAtTenantScope(String deploymentName) {
        return getAtTenantScopeWithResponse(deploymentName, Context.NONE).getValue();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.cancelAtTenantScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> cancelAtTenantScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.cancelAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelAtTenantScopeAsync(String deploymentName) {
        return cancelAtTenantScopeWithResponseAsync(deploymentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> cancelAtTenantScopeWithResponse(String deploymentName, Context context) {
        return cancelAtTenantScopeWithResponseAsync(deploymentName, context).block();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void cancelAtTenantScope(String deploymentName) {
        cancelAtTenantScopeWithResponse(deploymentName, Context.NONE);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateAtTenantScopeWithResponseAsync(String deploymentName,
        ScopedDeployment parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateAtTenantScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateAtTenantScopeWithResponseAsync(String deploymentName,
        ScopedDeployment parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(),
            parameters, accept, context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = validateAtTenantScopeWithResponseAsync(deploymentName, parameters);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            this.client.getContext());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtTenantScopeAsync(String deploymentName, ScopedDeployment parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateAtTenantScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return this.beginValidateAtTenantScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtTenantScope(String deploymentName, ScopedDeployment parameters, Context context) {
        return this.beginValidateAtTenantScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName,
        ScopedDeployment parameters) {
        return beginValidateAtTenantScopeAsync(deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAtTenantScopeAsync(String deploymentName,
        ScopedDeployment parameters, Context context) {
        return beginValidateAtTenantScopeAsync(deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtTenantScope(String deploymentName, ScopedDeployment parameters) {
        return validateAtTenantScopeAsync(deploymentName, parameters).block();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtTenantScope(String deploymentName, ScopedDeployment parameters,
        Context context) {
        return validateAtTenantScopeAsync(deploymentName, parameters, context).block();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> whatIfAtTenantScopeWithResponseAsync(String deploymentName,
        ScopedDeploymentWhatIf parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.whatIfAtTenantScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> whatIfAtTenantScopeWithResponseAsync(String deploymentName,
        ScopedDeploymentWhatIf parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.whatIfAtTenantScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(),
            parameters, accept, context);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = whatIfAtTenantScopeWithResponseAsync(deploymentName, parameters);
        return this.client.<WhatIfOperationResultInner, WhatIfOperationResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), WhatIfOperationResultInner.class, WhatIfOperationResultInner.class,
            this.client.getContext());
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtTenantScopeAsync(String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = whatIfAtTenantScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.<WhatIfOperationResultInner, WhatIfOperationResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), WhatIfOperationResultInner.class, WhatIfOperationResultInner.class, context);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.beginWhatIfAtTenantScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAtTenantScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName,
        ScopedDeploymentWhatIf parameters) {
        return beginWhatIfAtTenantScopeAsync(deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<WhatIfOperationResultInner> whatIfAtTenantScopeAsync(String deploymentName,
        ScopedDeploymentWhatIf parameters, Context context) {
        return beginWhatIfAtTenantScopeAsync(deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters) {
        return whatIfAtTenantScopeAsync(deploymentName, parameters).block();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the tenant group.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtTenantScope(String deploymentName, ScopedDeploymentWhatIf parameters,
        Context context) {
        return whatIfAtTenantScopeAsync(deploymentName, parameters, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>>
        exportTemplateAtTenantScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.exportTemplateAtTenantScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>>
        exportTemplateAtTenantScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.exportTemplateAtTenantScope(this.client.getEndpoint(), deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAtTenantScopeAsync(String deploymentName) {
        return exportTemplateAtTenantScopeWithResponseAsync(deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateAtTenantScopeWithResponse(String deploymentName,
        Context context) {
        return exportTemplateAtTenantScopeWithResponseAsync(deploymentName, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplateAtTenantScope(String deploymentName) {
        return exportTemplateAtTenantScopeWithResponse(deploymentName, Context.NONE).getValue();
    }

    /**
     * Get all the deployments at the tenant scope.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtTenantScopeSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAtTenantScope(this.client.getEndpoint(), filter, top,
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all the deployments at the tenant scope.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtTenantScopeSinglePageAsync(String filter, Integer top,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAtTenantScope(this.client.getEndpoint(), filter, top, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all the deployments at the tenant scope.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtTenantScopeAsync(String filter, Integer top) {
        return new PagedFlux<>(() -> listAtTenantScopeSinglePageAsync(filter, top),
            nextLink -> listAtTenantScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments at the tenant scope.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtTenantScopeAsync() {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listAtTenantScopeSinglePageAsync(filter, top),
            nextLink -> listAtTenantScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments at the tenant scope.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listAtTenantScopeAsync(String filter, Integer top, Context context) {
        return new PagedFlux<>(() -> listAtTenantScopeSinglePageAsync(filter, top, context),
            nextLink -> listAtTenantScopeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all the deployments at the tenant scope.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtTenantScope() {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listAtTenantScopeAsync(filter, top));
    }

    /**
     * Get all the deployments at the tenant scope.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments at the tenant scope as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtTenantScope(String filter, Integer top, Context context) {
        return new PagedIterable<>(listAtTenantScopeAsync(filter, top, context));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteAtManagementGroupScope(this.client.getEndpoint(), groupId,
                deploymentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupScopeAsync(String groupId,
        String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAtManagementGroupScopeWithResponseAsync(groupId, deploymentName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupScopeAsync(String groupId,
        String deploymentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroupScope(String groupId, String deploymentName) {
        return this.beginDeleteAtManagementGroupScopeAsync(groupId, deploymentName).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroupScope(String groupId, String deploymentName,
        Context context) {
        return this.beginDeleteAtManagementGroupScopeAsync(groupId, deploymentName, context).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return beginDeleteAtManagementGroupScopeAsync(groupId, deploymentName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAtManagementGroupScopeAsync(String groupId, String deploymentName, Context context) {
        return beginDeleteAtManagementGroupScopeAsync(groupId, deploymentName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtManagementGroupScope(String groupId, String deploymentName) {
        deleteAtManagementGroupScopeAsync(groupId, deploymentName).block();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtManagementGroupScope(String groupId, String deploymentName, Context context) {
        deleteAtManagementGroupScopeAsync(groupId, deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.checkExistenceAtManagementGroupScope(this.client.getEndpoint(), groupId,
                deploymentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkExistenceAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return checkExistenceAtManagementGroupScopeWithResponseAsync(groupId, deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> checkExistenceAtManagementGroupScopeWithResponse(String groupId, String deploymentName,
        Context context) {
        return checkExistenceAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean checkExistenceAtManagementGroupScope(String groupId, String deploymentName) {
        return checkExistenceAtManagementGroupScopeWithResponse(groupId, deploymentName, Context.NONE).getValue();
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, ScopedDeployment parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateAtManagementGroupScope(this.client.getEndpoint(), groupId,
                deploymentName, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, ScopedDeployment parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName,
            this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName,
            ScopedDeployment parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class,
            this.client.getContext());
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtManagementGroupScopeAsync(String groupId, String deploymentName,
            ScopedDeployment parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters, context);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class, context);
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.beginCreateOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).getSyncPoller();
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters,
            Context context) {
        return this.beginCreateOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(String groupId,
        String deploymentName, ScopedDeployment parameters) {
        return beginCreateOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAtManagementGroupScopeAsync(String groupId,
        String deploymentName, ScopedDeployment parameters, Context context) {
        return beginCreateOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtManagementGroupScope(String groupId, String deploymentName,
        ScopedDeployment parameters) {
        return createOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).block();
    }

    /**
     * Deploys resources at management group scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtManagementGroupScope(String groupId, String deploymentName,
        ScopedDeployment parameters, Context context) {
        return createOrUpdateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAtManagementGroupScope(this.client.getEndpoint(), groupId,
                deploymentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return getAtManagementGroupScopeWithResponseAsync(groupId, deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getAtManagementGroupScopeWithResponse(String groupId,
        String deploymentName, Context context) {
        return getAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner getAtManagementGroupScope(String groupId, String deploymentName) {
        return getAtManagementGroupScopeWithResponse(groupId, deploymentName, Context.NONE).getValue();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.cancelAtManagementGroupScope(this.client.getEndpoint(), groupId,
                deploymentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> cancelAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.cancelAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelAtManagementGroupScopeAsync(String groupId, String deploymentName) {
        return cancelAtManagementGroupScopeWithResponseAsync(groupId, deploymentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> cancelAtManagementGroupScopeWithResponse(String groupId, String deploymentName,
        Context context) {
        return cancelAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context).block();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void cancelAtManagementGroupScope(String groupId, String deploymentName) {
        cancelAtManagementGroupScopeWithResponse(groupId, deploymentName, Context.NONE);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, ScopedDeployment parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateAtManagementGroupScope(this.client.getEndpoint(), groupId,
                deploymentName, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, ScopedDeployment parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName,
            this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            this.client.getContext());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeployment parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters, context);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters) {
        return this.beginValidateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtManagementGroupScope(String groupId, String deploymentName, ScopedDeployment parameters,
            Context context) {
        return this.beginValidateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(String groupId,
        String deploymentName, ScopedDeployment parameters) {
        return beginValidateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAtManagementGroupScopeAsync(String groupId,
        String deploymentName, ScopedDeployment parameters, Context context) {
        return beginValidateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtManagementGroupScope(String groupId, String deploymentName,
        ScopedDeployment parameters) {
        return validateAtManagementGroupScopeAsync(groupId, deploymentName, parameters).block();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtManagementGroupScope(String groupId, String deploymentName,
        ScopedDeployment parameters, Context context) {
        return validateAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).block();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> whatIfAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, ScopedDeploymentWhatIf parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.whatIfAtManagementGroupScope(this.client.getEndpoint(), groupId,
                deploymentName, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> whatIfAtManagementGroupScopeWithResponseAsync(String groupId,
        String deploymentName, ScopedDeploymentWhatIf parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.whatIfAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName,
            this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtManagementGroupScopeAsync(String groupId, String deploymentName,
            ScopedDeploymentWhatIf parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = whatIfAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters);
        return this.client.<WhatIfOperationResultInner, WhatIfOperationResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), WhatIfOperationResultInner.class, WhatIfOperationResultInner.class,
            this.client.getContext());
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtManagementGroupScopeAsync(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = whatIfAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, parameters, context);
        return this.client.<WhatIfOperationResultInner, WhatIfOperationResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), WhatIfOperationResultInner.class, WhatIfOperationResultInner.class, context);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters) {
        return this.beginWhatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters).getSyncPoller();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtManagementGroupScope(String groupId, String deploymentName, ScopedDeploymentWhatIf parameters,
            Context context) {
        return this.beginWhatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(String groupId, String deploymentName,
        ScopedDeploymentWhatIf parameters) {
        return beginWhatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<WhatIfOperationResultInner> whatIfAtManagementGroupScopeAsync(String groupId, String deploymentName,
        ScopedDeploymentWhatIf parameters, Context context) {
        return beginWhatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtManagementGroupScope(String groupId, String deploymentName,
        ScopedDeploymentWhatIf parameters) {
        return whatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters).block();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the management group.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtManagementGroupScope(String groupId, String deploymentName,
        ScopedDeploymentWhatIf parameters, Context context) {
        return whatIfAtManagementGroupScopeAsync(groupId, deploymentName, parameters, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>>
        exportTemplateAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.exportTemplateAtManagementGroupScope(this.client.getEndpoint(), groupId,
                deploymentName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>>
        exportTemplateAtManagementGroupScopeWithResponseAsync(String groupId, String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.exportTemplateAtManagementGroupScope(this.client.getEndpoint(), groupId, deploymentName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeAsync(String groupId,
        String deploymentName) {
        return exportTemplateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateAtManagementGroupScopeWithResponse(String groupId,
        String deploymentName, Context context) {
        return exportTemplateAtManagementGroupScopeWithResponseAsync(groupId, deploymentName, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param groupId The management group ID.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplateAtManagementGroupScope(String groupId, String deploymentName) {
        return exportTemplateAtManagementGroupScopeWithResponse(groupId, deploymentName, Context.NONE).getValue();
    }

    /**
     * Get all the deployments for a management group.
     * 
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtManagementGroupScopeSinglePageAsync(String groupId,
        String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAtManagementGroupScope(this.client.getEndpoint(), groupId, filter, top,
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all the deployments for a management group.
     * 
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtManagementGroupScopeSinglePageAsync(String groupId,
        String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAtManagementGroupScope(this.client.getEndpoint(), groupId, filter, top, this.client.getApiVersion(),
                accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all the deployments for a management group.
     * 
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtManagementGroupScopeAsync(String groupId, String filter,
        Integer top) {
        return new PagedFlux<>(() -> listAtManagementGroupScopeSinglePageAsync(groupId, filter, top),
            nextLink -> listAtManagementGroupScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments for a management group.
     * 
     * @param groupId The management group ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAtManagementGroupScopeAsync(String groupId) {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listAtManagementGroupScopeSinglePageAsync(groupId, filter, top),
            nextLink -> listAtManagementGroupScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments for a management group.
     * 
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listAtManagementGroupScopeAsync(String groupId, String filter,
        Integer top, Context context) {
        return new PagedFlux<>(() -> listAtManagementGroupScopeSinglePageAsync(groupId, filter, top, context),
            nextLink -> listAtManagementGroupScopeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all the deployments for a management group.
     * 
     * @param groupId The management group ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtManagementGroupScope(String groupId) {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listAtManagementGroupScopeAsync(groupId, filter, top));
    }

    /**
     * Get all the deployments for a management group.
     * 
     * @param groupId The management group ID.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a management group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listAtManagementGroupScope(String groupId, String filter, Integer top,
        Context context) {
        return new PagedIterable<>(listAtManagementGroupScopeAsync(groupId, filter, top, context));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionScopeWithResponseAsync(String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAtSubscriptionScopeWithResponseAsync(deploymentName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionScopeAsync(String deploymentName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteAtSubscriptionScopeWithResponseAsync(deploymentName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscriptionScope(String deploymentName) {
        return this.beginDeleteAtSubscriptionScopeAsync(deploymentName).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscriptionScope(String deploymentName, Context context) {
        return this.beginDeleteAtSubscriptionScopeAsync(deploymentName, context).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtSubscriptionScopeAsync(String deploymentName) {
        return beginDeleteAtSubscriptionScopeAsync(deploymentName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAtSubscriptionScopeAsync(String deploymentName, Context context) {
        return beginDeleteAtSubscriptionScopeAsync(deploymentName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtSubscriptionScope(String deploymentName) {
        deleteAtSubscriptionScopeAsync(deploymentName).block();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. This is an asynchronous operation that returns a status of 202 until the
     * template deployment is successfully deleted. The Location response header contains the URI that is used to obtain
     * the status of the process. While the process is running, a call to the URI in the Location header returns a
     * status of 202. When the process finishes, the URI in the Location header returns a status of 204 on success. If
     * the asynchronous request failed, the URI in the Location header returns an error-level status code.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtSubscriptionScope(String deploymentName, Context context) {
        deleteAtSubscriptionScopeAsync(deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.checkExistenceAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceAtSubscriptionScopeWithResponseAsync(String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkExistenceAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAtSubscriptionScopeAsync(String deploymentName) {
        return checkExistenceAtSubscriptionScopeWithResponseAsync(deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> checkExistenceAtSubscriptionScopeWithResponse(String deploymentName, Context context) {
        return checkExistenceAtSubscriptionScopeWithResponseAsync(deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean checkExistenceAtSubscriptionScope(String deploymentName) {
        return checkExistenceAtSubscriptionScopeWithResponse(deploymentName, Context.NONE).getValue();
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionScopeWithResponseAsync(String deploymentName,
        DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionScopeWithResponseAsync(String deploymentName,
        DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtSubscriptionScopeWithResponseAsync(deploymentName, parameters);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class,
            this.client.getContext());
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtSubscriptionScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class, context);
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(String deploymentName,
        DeploymentInner parameters) {
        return beginCreateOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAtSubscriptionScopeAsync(String deploymentName,
        DeploymentInner parameters, Context context) {
        return beginCreateOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtSubscriptionScope(String deploymentName,
        DeploymentInner parameters) {
        return createOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters).block();
    }

    /**
     * Deploys resources at subscription scope.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdateAtSubscriptionScope(String deploymentName, DeploymentInner parameters,
        Context context) {
        return createOrUpdateAtSubscriptionScopeAsync(deploymentName, parameters, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getAtSubscriptionScopeWithResponseAsync(String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getAtSubscriptionScopeAsync(String deploymentName) {
        return getAtSubscriptionScopeWithResponseAsync(deploymentName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getAtSubscriptionScopeWithResponse(String deploymentName,
        Context context) {
        return getAtSubscriptionScopeWithResponseAsync(deploymentName, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner getAtSubscriptionScope(String deploymentName) {
        return getAtSubscriptionScopeWithResponse(deploymentName, Context.NONE).getValue();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.cancelAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> cancelAtSubscriptionScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.cancelAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelAtSubscriptionScopeAsync(String deploymentName) {
        return cancelAtSubscriptionScopeWithResponseAsync(deploymentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> cancelAtSubscriptionScopeWithResponse(String deploymentName, Context context) {
        return cancelAtSubscriptionScopeWithResponseAsync(deploymentName, context).block();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resources partially deployed.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void cancelAtSubscriptionScope(String deploymentName) {
        cancelAtSubscriptionScopeWithResponse(deploymentName, Context.NONE);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateAtSubscriptionScopeWithResponseAsync(String deploymentName,
        DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateAtSubscriptionScopeWithResponseAsync(String deploymentName,
        DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateAtSubscriptionScopeWithResponseAsync(deploymentName, parameters);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            this.client.getContext());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtSubscriptionScopeAsync(String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateAtSubscriptionScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtSubscriptionScope(String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAtSubscriptionScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAtSubscriptionScope(String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAtSubscriptionScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(String deploymentName,
        DeploymentInner parameters) {
        return beginValidateAtSubscriptionScopeAsync(deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAtSubscriptionScopeAsync(String deploymentName,
        DeploymentInner parameters, Context context) {
        return beginValidateAtSubscriptionScopeAsync(deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtSubscriptionScope(String deploymentName,
        DeploymentInner parameters) {
        return validateAtSubscriptionScopeAsync(deploymentName, parameters).block();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validateAtSubscriptionScope(String deploymentName, DeploymentInner parameters,
        Context context) {
        return validateAtSubscriptionScopeAsync(deploymentName, parameters, context).block();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> whatIfAtSubscriptionScopeWithResponseAsync(String deploymentName,
        DeploymentWhatIf parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.whatIfAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> whatIfAtSubscriptionScopeWithResponseAsync(String deploymentName,
        DeploymentWhatIf parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.whatIfAtSubscriptionScope(this.client.getEndpoint(), deploymentName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = whatIfAtSubscriptionScopeWithResponseAsync(deploymentName, parameters);
        return this.client.<WhatIfOperationResultInner, WhatIfOperationResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), WhatIfOperationResultInner.class, WhatIfOperationResultInner.class,
            this.client.getContext());
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtSubscriptionScopeAsync(String deploymentName, DeploymentWhatIf parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = whatIfAtSubscriptionScopeWithResponseAsync(deploymentName, parameters, context);
        return this.client.<WhatIfOperationResultInner, WhatIfOperationResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), WhatIfOperationResultInner.class, WhatIfOperationResultInner.class, context);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters) {
        return this.beginWhatIfAtSubscriptionScopeAsync(deploymentName, parameters).getSyncPoller();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAtSubscriptionScopeAsync(deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName,
        DeploymentWhatIf parameters) {
        return beginWhatIfAtSubscriptionScopeAsync(deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<WhatIfOperationResultInner> whatIfAtSubscriptionScopeAsync(String deploymentName,
        DeploymentWhatIf parameters, Context context) {
        return beginWhatIfAtSubscriptionScopeAsync(deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters) {
        return whatIfAtSubscriptionScopeAsync(deploymentName, parameters).block();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the subscription.
     * 
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to What If.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIfAtSubscriptionScope(String deploymentName, DeploymentWhatIf parameters,
        Context context) {
        return whatIfAtSubscriptionScopeAsync(deploymentName, parameters, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>>
        exportTemplateAtSubscriptionScopeWithResponseAsync(String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.exportTemplateAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>>
        exportTemplateAtSubscriptionScopeWithResponseAsync(String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.exportTemplateAtSubscriptionScope(this.client.getEndpoint(), deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeAsync(String deploymentName) {
        return exportTemplateAtSubscriptionScopeWithResponseAsync(deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateAtSubscriptionScopeWithResponse(String deploymentName,
        Context context) {
        return exportTemplateAtSubscriptionScopeWithResponseAsync(deploymentName, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplateAtSubscriptionScope(String deploymentName) {
        return exportTemplateAtSubscriptionScopeWithResponse(deploymentName, Context.NONE).getValue();
    }

    /**
     * Get all the deployments for a subscription.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), filter, top, this.client.getApiVersion(),
                this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all the deployments for a subscription.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listSinglePageAsync(String filter, Integer top,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), filter, top, this.client.getApiVersion(), this.client.getSubscriptionId(),
                accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all the deployments for a subscription.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAsync(String filter, Integer top) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter, top),
            nextLink -> listAtSubscriptionScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments for a subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listAsync() {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listSinglePageAsync(filter, top),
            nextLink -> listAtSubscriptionScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments for a subscription.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listAsync(String filter, Integer top, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(filter, top, context),
            nextLink -> listAtSubscriptionScopeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all the deployments for a subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> list() {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listAsync(filter, top));
    }

    /**
     * Get all the deployments for a subscription.
     * 
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> list(String filter, Integer top, Context context) {
        return new PagedIterable<>(listAsync(filter, top, context));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, deploymentName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, deploymentName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentName) {
        return this.beginDeleteAsync(resourceGroupName, deploymentName).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentName,
        Context context) {
        return this.beginDeleteAsync(resourceGroupName, deploymentName, context).getSyncPoller();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String deploymentName) {
        return beginDeleteAsync(resourceGroupName, deploymentName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String deploymentName, Context context) {
        return beginDeleteAsync(resourceGroupName, deploymentName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String deploymentName) {
        deleteAsync(resourceGroupName, deploymentName).block();
    }

    /**
     * Deletes a deployment from the deployment history.
     * 
     * A template deployment that is currently running cannot be deleted. Deleting a template deployment removes the
     * associated deployment operations. Deleting a template deployment does not affect the state of the resource group.
     * This is an asynchronous operation that returns a status of 202 until the template deployment is successfully
     * deleted. The Location response header contains the URI that is used to obtain the status of the process. While
     * the process is running, a call to the URI in the Location header returns a status of 202. When the process
     * finishes, the URI in the Location header returns a status of 204 on success. If the asynchronous request failed,
     * the URI in the Location header returns an error-level status code.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to delete. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String deploymentName, Context context) {
        deleteAsync(resourceGroupName, deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkExistenceWithResponseAsync(String resourceGroupName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.checkExistence(this.client.getEndpoint(), resourceGroupName, deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Boolean>> checkExistenceWithResponseAsync(String resourceGroupName, String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkExistence(this.client.getEndpoint(), resourceGroupName, deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Boolean> checkExistenceAsync(String resourceGroupName, String deploymentName) {
        return checkExistenceWithResponseAsync(resourceGroupName, deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Boolean> checkExistenceWithResponse(String resourceGroupName, String deploymentName,
        Context context) {
        return checkExistenceWithResponseAsync(resourceGroupName, deploymentName, context).block();
    }

    /**
     * Checks whether the deployment exists.
     * 
     * @param resourceGroupName The name of the resource group with the deployment to check. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return whether resource exists.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public boolean checkExistence(String resourceGroupName, String deploymentName) {
        return checkExistenceWithResponse(resourceGroupName, deploymentName, Context.NONE).getValue();
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String deploymentName, DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String deploymentName, DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, deploymentName, parameters);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class,
            this.client.getContext());
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, deploymentName, parameters, context);
        return this.client.<DeploymentExtendedInner, DeploymentExtendedInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentExtendedInner.class, DeploymentExtendedInner.class, context);
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner>
        beginCreateOrUpdate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, deploymentName, parameters).getSyncPoller();
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentExtendedInner>, DeploymentExtendedInner> beginCreateOrUpdate(
        String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> createOrUpdateAsync(String resourceGroupName, String deploymentName,
        DeploymentInner parameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentExtendedInner> createOrUpdateAsync(String resourceGroupName, String deploymentName,
        DeploymentInner parameters, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdate(String resourceGroupName, String deploymentName,
        DeploymentInner parameters) {
        return createOrUpdateAsync(resourceGroupName, deploymentName, parameters).block();
    }

    /**
     * Deploys resources to a resource group.
     * 
     * You can provide the template and parameters directly in the request or link to JSON files.
     * 
     * @param resourceGroupName The name of the resource group to deploy the resources to. The name is case insensitive.
     * The resource group must already exist.
     * @param deploymentName The name of the deployment.
     * @param parameters Additional parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner createOrUpdate(String resourceGroupName, String deploymentName,
        DeploymentInner parameters, Context context) {
        return createOrUpdateAsync(resourceGroupName, deploymentName, parameters, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExtendedInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName,
                deploymentName, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExtendedInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Gets a deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExtendedInner> getByResourceGroupAsync(String resourceGroupName, String deploymentName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExtendedInner> getByResourceGroupWithResponse(String resourceGroupName,
        String deploymentName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, deploymentName, context).block();
    }

    /**
     * Gets a deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a deployment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExtendedInner getByResourceGroup(String resourceGroupName, String deploymentName) {
        return getByResourceGroupWithResponse(resourceGroupName, deploymentName, Context.NONE).getValue();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.cancel(this.client.getEndpoint(), resourceGroupName, deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String deploymentName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.cancel(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelAsync(String resourceGroupName, String deploymentName) {
        return cancelWithResponseAsync(resourceGroupName, deploymentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> cancelWithResponse(String resourceGroupName, String deploymentName, Context context) {
        return cancelWithResponseAsync(resourceGroupName, deploymentName, context).block();
    }

    /**
     * Cancels a currently running template deployment.
     * 
     * You can cancel a deployment only if the provisioningState is Accepted or Running. After the deployment is
     * canceled, the provisioningState is set to Canceled. Canceling a template deployment stops the currently running
     * template deployment and leaves the resource group partially deployed.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String deploymentName) {
        cancelWithResponse(resourceGroupName, deploymentName, Context.NONE);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String deploymentName,
        DeploymentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validate(this.client.getEndpoint(), resourceGroupName, deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String deploymentName,
        DeploymentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validate(this.client.getEndpoint(), resourceGroupName, deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidateAsync(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateWithResponseAsync(resourceGroupName, deploymentName, parameters);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            this.client.getContext());
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner> beginValidateAsync(
        String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateWithResponseAsync(resourceGroupName, deploymentName, parameters, context);
        return this.client.<DeploymentValidateResultInner, DeploymentValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentValidateResultInner.class, DeploymentValidateResultInner.class,
            context);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidate(String resourceGroupName, String deploymentName, DeploymentInner parameters) {
        return this.beginValidateAsync(resourceGroupName, deploymentName, parameters).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentValidateResultInner>, DeploymentValidateResultInner>
        beginValidate(String resourceGroupName, String deploymentName, DeploymentInner parameters, Context context) {
        return this.beginValidateAsync(resourceGroupName, deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentValidateResultInner> validateAsync(String resourceGroupName, String deploymentName,
        DeploymentInner parameters) {
        return beginValidateAsync(resourceGroupName, deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentValidateResultInner> validateAsync(String resourceGroupName, String deploymentName,
        DeploymentInner parameters, Context context) {
        return beginValidateAsync(resourceGroupName, deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validate(String resourceGroupName, String deploymentName,
        DeploymentInner parameters) {
        return validateAsync(resourceGroupName, deploymentName, parameters).block();
    }

    /**
     * Validates whether the specified template is syntactically correct and will be accepted by Azure Resource
     * Manager..
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information from validate template deployment response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentValidateResultInner validate(String resourceGroupName, String deploymentName,
        DeploymentInner parameters, Context context) {
        return validateAsync(resourceGroupName, deploymentName, parameters, context).block();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> whatIfWithResponseAsync(String resourceGroupName, String deploymentName,
        DeploymentWhatIf parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.whatIf(this.client.getEndpoint(), resourceGroupName, deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> whatIfWithResponseAsync(String resourceGroupName, String deploymentName,
        DeploymentWhatIf parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.whatIf(this.client.getEndpoint(), resourceGroupName, deploymentName, this.client.getApiVersion(),
            this.client.getSubscriptionId(), parameters, accept, context);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIfAsync(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = whatIfWithResponseAsync(resourceGroupName, deploymentName, parameters);
        return this.client.<WhatIfOperationResultInner, WhatIfOperationResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), WhatIfOperationResultInner.class, WhatIfOperationResultInner.class,
            this.client.getContext());
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner> beginWhatIfAsync(
        String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = whatIfWithResponseAsync(resourceGroupName, deploymentName, parameters, context);
        return this.client.<WhatIfOperationResultInner, WhatIfOperationResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), WhatIfOperationResultInner.class, WhatIfOperationResultInner.class, context);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters) {
        return this.beginWhatIfAsync(resourceGroupName, deploymentName, parameters).getSyncPoller();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WhatIfOperationResultInner>, WhatIfOperationResultInner>
        beginWhatIf(String resourceGroupName, String deploymentName, DeploymentWhatIf parameters, Context context) {
        return this.beginWhatIfAsync(resourceGroupName, deploymentName, parameters, context).getSyncPoller();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<WhatIfOperationResultInner> whatIfAsync(String resourceGroupName, String deploymentName,
        DeploymentWhatIf parameters) {
        return beginWhatIfAsync(resourceGroupName, deploymentName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<WhatIfOperationResultInner> whatIfAsync(String resourceGroupName, String deploymentName,
        DeploymentWhatIf parameters, Context context) {
        return beginWhatIfAsync(resourceGroupName, deploymentName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIf(String resourceGroupName, String deploymentName,
        DeploymentWhatIf parameters) {
        return whatIfAsync(resourceGroupName, deploymentName, parameters).block();
    }

    /**
     * Returns changes that will be made by the deployment if executed at the scope of the resource group.
     * 
     * @param resourceGroupName The name of the resource group the template will be deployed to. The name is case
     * insensitive.
     * @param deploymentName The name of the deployment.
     * @param parameters Parameters to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the What-If operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WhatIfOperationResultInner whatIf(String resourceGroupName, String deploymentName,
        DeploymentWhatIf parameters, Context context) {
        return whatIfAsync(resourceGroupName, deploymentName, parameters, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentExportResultInner>> exportTemplateWithResponseAsync(String resourceGroupName,
        String deploymentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.exportTemplate(this.client.getEndpoint(), resourceGroupName, deploymentName,
                this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentExportResultInner>> exportTemplateWithResponseAsync(String resourceGroupName,
        String deploymentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter deploymentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.exportTemplate(this.client.getEndpoint(), resourceGroupName, deploymentName,
            this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context);
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentExportResultInner> exportTemplateAsync(String resourceGroupName, String deploymentName) {
        return exportTemplateWithResponseAsync(resourceGroupName, deploymentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentExportResultInner> exportTemplateWithResponse(String resourceGroupName,
        String deploymentName, Context context) {
        return exportTemplateWithResponseAsync(resourceGroupName, deploymentName, context).block();
    }

    /**
     * Exports the template used for specified deployment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentName The name of the deployment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deployment export result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentExportResultInner exportTemplate(String resourceGroupName, String deploymentName) {
        return exportTemplateWithResponse(resourceGroupName, deploymentName, Context.NONE).getValue();
    }

    /**
     * Get all the deployments for a resource group.
     * 
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     * insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, filter,
                top, this.client.getApiVersion(), this.client.getSubscriptionId(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all the deployments for a resource group.
     * 
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     * insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), resourceGroupName, filter, top, this.client.getApiVersion(),
                this.client.getSubscriptionId(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all the deployments for a resource group.
     * 
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     * insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listByResourceGroupAsync(String resourceGroupName, String filter,
        Integer top) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, top),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments for a resource group.
     * 
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     * insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentExtendedInner> listByResourceGroupAsync(String resourceGroupName) {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, top),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Get all the deployments for a resource group.
     * 
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     * insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentExtendedInner> listByResourceGroupAsync(String resourceGroupName, String filter,
        Integer top, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, filter, top, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all the deployments for a resource group.
     * 
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     * insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listByResourceGroup(String resourceGroupName) {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter, top));
    }

    /**
     * Get all the deployments for a resource group.
     * 
     * @param resourceGroupName The name of the resource group with the deployments to get. The name is case
     * insensitive.
     * @param filter The filter to apply on the operation. For example, you can use $filter=provisioningState eq
     * '{state}'.
     * @param top The number of results to get. If null is passed, returns all deployments.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the deployments for a resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentExtendedInner> listByResourceGroup(String resourceGroupName, String filter,
        Integer top, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, filter, top, context));
    }

    /**
     * Calculate the hash of the given template.
     * 
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TemplateHashResultInner>> calculateTemplateHashWithResponseAsync(Object template) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (template == null) {
            return Mono.error(new IllegalArgumentException("Parameter template is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.calculateTemplateHash(this.client.getEndpoint(),
                this.client.getApiVersion(), template, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Calculate the hash of the given template.
     * 
     * @param template The template provided to calculate hash.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TemplateHashResultInner>> calculateTemplateHashWithResponseAsync(Object template,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (template == null) {
            return Mono.error(new IllegalArgumentException("Parameter template is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.calculateTemplateHash(this.client.getEndpoint(), this.client.getApiVersion(), template, accept,
            context);
    }

    /**
     * Calculate the hash of the given template.
     * 
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TemplateHashResultInner> calculateTemplateHashAsync(Object template) {
        return calculateTemplateHashWithResponseAsync(template).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Calculate the hash of the given template.
     * 
     * @param template The template provided to calculate hash.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TemplateHashResultInner> calculateTemplateHashWithResponse(Object template, Context context) {
        return calculateTemplateHashWithResponseAsync(template, context).block();
    }

    /**
     * Calculate the hash of the given template.
     * 
     * @param template The template provided to calculate hash.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to calculate template hash.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TemplateHashResultInner calculateTemplateHash(Object template) {
        return calculateTemplateHashWithResponse(template, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAtScopeNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtScopeNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAtScopeNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtTenantScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAtTenantScopeNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtTenantScopeNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAtTenantScopeNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>>
        listAtManagementGroupScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listAtManagementGroupScopeNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtManagementGroupScopeNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAtManagementGroupScopeNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtSubscriptionScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listAtSubscriptionScopeNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listAtSubscriptionScopeNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAtSubscriptionScopeNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeploymentExtendedInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentExtendedInner>> listByResourceGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
