// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The resource selector to filter policies by resource properties.
 */
@Fluent
public final class ResourceSelector implements JsonSerializable<ResourceSelector> {
    /*
     * The name of the resource selector.
     */
    private String name;

    /*
     * The list of the selector expressions.
     */
    private List<Selector> selectors;

    /**
     * Creates an instance of ResourceSelector class.
     */
    public ResourceSelector() {
    }

    /**
     * Get the name property: The name of the resource selector.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource selector.
     * 
     * @param name the name value to set.
     * @return the ResourceSelector object itself.
     */
    public ResourceSelector withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the selectors property: The list of the selector expressions.
     * 
     * @return the selectors value.
     */
    public List<Selector> selectors() {
        return this.selectors;
    }

    /**
     * Set the selectors property: The list of the selector expressions.
     * 
     * @param selectors the selectors value to set.
     * @return the ResourceSelector object itself.
     */
    public ResourceSelector withSelectors(List<Selector> selectors) {
        this.selectors = selectors;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (selectors() != null) {
            selectors().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("selectors", this.selectors, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSelector from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSelector if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSelector.
     */
    public static ResourceSelector fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSelector deserializedResourceSelector = new ResourceSelector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedResourceSelector.name = reader.getString();
                } else if ("selectors".equals(fieldName)) {
                    List<Selector> selectors = reader.readArray(reader1 -> Selector.fromJson(reader1));
                    deserializedResourceSelector.selectors = selectors;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSelector;
        });
    }
}
