// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Subscription policies.
 */
@Immutable
public final class SubscriptionPolicies implements JsonSerializable<SubscriptionPolicies> {
    /*
     * The subscription location placement ID. The ID indicates which regions are visible for a subscription. For
     * example, a subscription with a location placement Id of Public_2014-09-01 has access to Azure public regions.
     */
    private String locationPlacementId;

    /*
     * The subscription quota ID.
     */
    private String quotaId;

    /*
     * The subscription spending limit.
     */
    private SpendingLimit spendingLimit;

    /**
     * Creates an instance of SubscriptionPolicies class.
     */
    public SubscriptionPolicies() {
    }

    /**
     * Get the locationPlacementId property: The subscription location placement ID. The ID indicates which regions are
     * visible for a subscription. For example, a subscription with a location placement Id of Public_2014-09-01 has
     * access to Azure public regions.
     * 
     * @return the locationPlacementId value.
     */
    public String locationPlacementId() {
        return this.locationPlacementId;
    }

    /**
     * Get the quotaId property: The subscription quota ID.
     * 
     * @return the quotaId value.
     */
    public String quotaId() {
        return this.quotaId;
    }

    /**
     * Get the spendingLimit property: The subscription spending limit.
     * 
     * @return the spendingLimit value.
     */
    public SpendingLimit spendingLimit() {
        return this.spendingLimit;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionPolicies from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionPolicies if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubscriptionPolicies.
     */
    public static SubscriptionPolicies fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionPolicies deserializedSubscriptionPolicies = new SubscriptionPolicies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locationPlacementId".equals(fieldName)) {
                    deserializedSubscriptionPolicies.locationPlacementId = reader.getString();
                } else if ("quotaId".equals(fieldName)) {
                    deserializedSubscriptionPolicies.quotaId = reader.getString();
                } else if ("spendingLimit".equals(fieldName)) {
                    deserializedSubscriptionPolicies.spendingLimit = SpendingLimit.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubscriptionPolicies;
        });
    }
}
