// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ResourceNameStatus;
import java.io.IOException;

/**
 * Resource Name valid if not a reserved word, does not contain a reserved word and does not start with a reserved word.
 */
@Fluent
public final class CheckResourceNameResultInner implements JsonSerializable<CheckResourceNameResultInner> {
    /*
     * Name of Resource
     */
    private String name;

    /*
     * Type of Resource
     */
    private String type;

    /*
     * Is the resource name Allowed or Reserved
     */
    private ResourceNameStatus status;

    /**
     * Creates an instance of CheckResourceNameResultInner class.
     */
    public CheckResourceNameResultInner() {
    }

    /**
     * Get the name property: Name of Resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of Resource.
     * 
     * @param name the name value to set.
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Type of Resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of Resource.
     * 
     * @param type the type value to set.
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the status property: Is the resource name Allowed or Reserved.
     * 
     * @return the status value.
     */
    public ResourceNameStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Is the resource name Allowed or Reserved.
     * 
     * @param status the status value to set.
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withStatus(ResourceNameStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckResourceNameResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckResourceNameResultInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CheckResourceNameResultInner.
     */
    public static CheckResourceNameResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckResourceNameResultInner deserializedCheckResourceNameResultInner = new CheckResourceNameResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCheckResourceNameResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCheckResourceNameResultInner.type = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedCheckResourceNameResultInner.status = ResourceNameStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckResourceNameResultInner;
        });
    }
}
