// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ActionOnUnmanage;
import com.azure.resourcemanager.resources.models.AzureResourceBase;
import com.azure.resourcemanager.resources.models.DenySettings;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.DeploymentStackProvisioningState;
import com.azure.resourcemanager.resources.models.DeploymentStacksDebugSetting;
import com.azure.resourcemanager.resources.models.DeploymentStacksParametersLink;
import com.azure.resourcemanager.resources.models.DeploymentStacksTemplateLink;
import com.azure.resourcemanager.resources.models.ManagedResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReferenceExtended;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Deployment stack object.
 */
@Fluent
public final class DeploymentStackInner extends AzureResourceBase {
    /*
     * The location of the Deployment stack. It cannot be changed after creation. It must be one of the supported Azure
     * locations.
     */
    private String location;

    /*
     * Deployment stack resource tags.
     */
    private Map<String, String> tags;

    /*
     * Deployment stack properties.
     */
    private DeploymentStackProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DeploymentStackInner class.
     */
    public DeploymentStackInner() {
    }

    /**
     * Get the location property: The location of the Deployment stack. It cannot be changed after creation. It must be
     * one of the supported Azure locations.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the Deployment stack. It cannot be changed after creation. It must be
     * one of the supported Azure locations.
     * 
     * @param location the location value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the tags property: Deployment stack resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Deployment stack resource tags.
     * 
     * @param tags the tags value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: Deployment stack properties.
     * 
     * @return the innerProperties value.
     */
    private DeploymentStackProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the template property: The template content. You use this element when you want to pass the template syntax
     * directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string.
     * Use either the templateLink property or the template property, but not both.
     * 
     * @return the template value.
     */
    public Object template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    /**
     * Set the template property: The template content. You use this element when you want to pass the template syntax
     * directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string.
     * Use either the templateLink property or the template property, but not both.
     * 
     * @param template the template value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withTemplate(Object template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    /**
     * Get the templateLink property: The URI of the template. Use either the templateLink property or the template
     * property, but not both.
     * 
     * @return the templateLink value.
     */
    public DeploymentStacksTemplateLink templateLink() {
        return this.innerProperties() == null ? null : this.innerProperties().templateLink();
    }

    /**
     * Set the templateLink property: The URI of the template. Use either the templateLink property or the template
     * property, but not both.
     * 
     * @param templateLink the templateLink value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withTemplateLink(DeploymentStacksTemplateLink templateLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withTemplateLink(templateLink);
        return this;
    }

    /**
     * Get the parameters property: Name and value pairs that define the deployment parameters for the template. Use
     * this element when providing the parameter values directly in the request, rather than linking to an existing
     * parameter file. Use either the parametersLink property or the parameters property, but not both.
     * 
     * @return the parameters value.
     */
    public Map<String, DeploymentParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: Name and value pairs that define the deployment parameters for the template. Use
     * this element when providing the parameter values directly in the request, rather than linking to an existing
     * parameter file. Use either the parametersLink property or the parameters property, but not both.
     * 
     * @param parameters the parameters value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withParameters(Map<String, DeploymentParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Get the parametersLink property: The URI of parameters file. Use this element to link to an existing parameters
     * file. Use either the parametersLink property or the parameters property, but not both.
     * 
     * @return the parametersLink value.
     */
    public DeploymentStacksParametersLink parametersLink() {
        return this.innerProperties() == null ? null : this.innerProperties().parametersLink();
    }

    /**
     * Set the parametersLink property: The URI of parameters file. Use this element to link to an existing parameters
     * file. Use either the parametersLink property or the parameters property, but not both.
     * 
     * @param parametersLink the parametersLink value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withParametersLink(DeploymentStacksParametersLink parametersLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withParametersLink(parametersLink);
        return this;
    }

    /**
     * Get the actionOnUnmanage property: Defines the behavior of resources that are no longer managed after the
     * Deployment stack is updated or deleted.
     * 
     * @return the actionOnUnmanage value.
     */
    public ActionOnUnmanage actionOnUnmanage() {
        return this.innerProperties() == null ? null : this.innerProperties().actionOnUnmanage();
    }

    /**
     * Set the actionOnUnmanage property: Defines the behavior of resources that are no longer managed after the
     * Deployment stack is updated or deleted.
     * 
     * @param actionOnUnmanage the actionOnUnmanage value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withActionOnUnmanage(ActionOnUnmanage actionOnUnmanage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withActionOnUnmanage(actionOnUnmanage);
        return this;
    }

    /**
     * Get the debugSetting property: The debug setting of the deployment.
     * 
     * @return the debugSetting value.
     */
    public DeploymentStacksDebugSetting debugSetting() {
        return this.innerProperties() == null ? null : this.innerProperties().debugSetting();
    }

    /**
     * Set the debugSetting property: The debug setting of the deployment.
     * 
     * @param debugSetting the debugSetting value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withDebugSetting(DeploymentStacksDebugSetting debugSetting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withDebugSetting(debugSetting);
        return this;
    }

    /**
     * Get the bypassStackOutOfSyncError property: Flag to bypass service errors that indicate the stack resource list
     * is not correctly synchronized.
     * 
     * @return the bypassStackOutOfSyncError value.
     */
    public Boolean bypassStackOutOfSyncError() {
        return this.innerProperties() == null ? null : this.innerProperties().bypassStackOutOfSyncError();
    }

    /**
     * Set the bypassStackOutOfSyncError property: Flag to bypass service errors that indicate the stack resource list
     * is not correctly synchronized.
     * 
     * @param bypassStackOutOfSyncError the bypassStackOutOfSyncError value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withBypassStackOutOfSyncError(Boolean bypassStackOutOfSyncError) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withBypassStackOutOfSyncError(bypassStackOutOfSyncError);
        return this;
    }

    /**
     * Get the deploymentScope property: The scope at which the initial deployment should be created. If a scope is not
     * specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
     * 
     * @return the deploymentScope value.
     */
    public String deploymentScope() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentScope();
    }

    /**
     * Set the deploymentScope property: The scope at which the initial deployment should be created. If a scope is not
     * specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
     * 
     * @param deploymentScope the deploymentScope value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withDeploymentScope(String deploymentScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withDeploymentScope(deploymentScope);
        return this;
    }

    /**
     * Get the description property: Deployment stack description. Max length of 4096 characters.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Deployment stack description. Max length of 4096 characters.
     * 
     * @param description the description value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the denySettings property: Defines how resources deployed by the stack are locked.
     * 
     * @return the denySettings value.
     */
    public DenySettings denySettings() {
        return this.innerProperties() == null ? null : this.innerProperties().denySettings();
    }

    /**
     * Set the denySettings property: Defines how resources deployed by the stack are locked.
     * 
     * @param denySettings the denySettings value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withDenySettings(DenySettings denySettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withDenySettings(denySettings);
        return this;
    }

    /**
     * Get the provisioningState property: State of the deployment stack.
     * 
     * @return the provisioningState value.
     */
    public DeploymentStackProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the correlationId property: The correlation id of the last Deployment stack upsert or delete operation. It is
     * in GUID format and is used for tracing.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationId();
    }

    /**
     * Get the detachedResources property: An array of resources that were detached during the most recent Deployment
     * stack update. Detached means that the resource was removed from the template, but no relevant deletion operations
     * were specified. So, the resource still exists while no longer being associated with the stack.
     * 
     * @return the detachedResources value.
     */
    public List<ResourceReference> detachedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().detachedResources();
    }

    /**
     * Get the deletedResources property: An array of resources that were deleted during the most recent Deployment
     * stack update. Deleted means that the resource was removed from the template and relevant deletion operations were
     * specified.
     * 
     * @return the deletedResources value.
     */
    public List<ResourceReference> deletedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().deletedResources();
    }

    /**
     * Get the failedResources property: An array of resources that failed to reach goal state during the most recent
     * update. Each resourceId is accompanied by an error message.
     * 
     * @return the failedResources value.
     */
    public List<ResourceReferenceExtended> failedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().failedResources();
    }

    /**
     * Get the resources property: An array of resources currently managed by the deployment stack.
     * 
     * @return the resources value.
     */
    public List<ManagedResourceReference> resources() {
        return this.innerProperties() == null ? null : this.innerProperties().resources();
    }

    /**
     * Get the deploymentId property: The resourceId of the deployment resource created by the deployment stack.
     * 
     * @return the deploymentId value.
     */
    public String deploymentId() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentId();
    }

    /**
     * Get the outputs property: The outputs of the deployment resource created by the deployment stack.
     * 
     * @return the outputs value.
     */
    public Object outputs() {
        return this.innerProperties() == null ? null : this.innerProperties().outputs();
    }

    /**
     * Get the duration property: The duration of the last successful Deployment stack update.
     * 
     * @return the duration value.
     */
    public String duration() {
        return this.innerProperties() == null ? null : this.innerProperties().duration();
    }

    /**
     * Get the error property: The error detail.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    /**
     * Set the error property: The error detail.
     * 
     * @param error the error value to set.
     * @return the DeploymentStackInner object itself.
     */
    public DeploymentStackInner withError(ManagementError error) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentStackProperties();
        }
        this.innerProperties().withError(error);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentStackInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentStackInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeploymentStackInner.
     */
    public static DeploymentStackInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentStackInner deserializedDeploymentStackInner = new DeploymentStackInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDeploymentStackInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDeploymentStackInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDeploymentStackInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedDeploymentStackInner.systemData = SystemData.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedDeploymentStackInner.location = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeploymentStackInner.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedDeploymentStackInner.innerProperties = DeploymentStackProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentStackInner;
        });
    }
}
